/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;
import uk.co.real_logic.artio.storage.messages.PreviousRecordingDecoder;

public final class PreviousRecordingEncoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 30;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 11;
    public static final String SEMANTIC_VERSION = "0.1";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final PreviousRecordingEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private final InboundRecordingsEncoder inboundRecordings = new InboundRecordingsEncoder(this);
    private final OutboundRecordingsEncoder outboundRecordings = new OutboundRecordingsEncoder(this);

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 30;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 11;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public PreviousRecordingEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 8);
        return this;
    }

    public PreviousRecordingEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(8).templateId(30).schemaId(666).version(11);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int reproductionRecordingIdId() {
        return 3;
    }

    public static int reproductionRecordingIdSinceVersion() {
        return 11;
    }

    public static int reproductionRecordingIdEncodingOffset() {
        return 0;
    }

    public static int reproductionRecordingIdEncodingLength() {
        return 8;
    }

    public static String reproductionRecordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long reproductionRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long reproductionRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long reproductionRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public PreviousRecordingEncoder reproductionRecordingId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static long inboundRecordingsId() {
        return 1L;
    }

    public InboundRecordingsEncoder inboundRecordingsCount(int count) {
        this.inboundRecordings.wrap(this.buffer, count);
        return this.inboundRecordings;
    }

    public static long outboundRecordingsId() {
        return 2L;
    }

    public OutboundRecordingsEncoder outboundRecordingsCount(int count) {
        this.outboundRecordings.wrap(this.buffer, count);
        return this.outboundRecordings;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        PreviousRecordingDecoder decoder = new PreviousRecordingDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 8, 11);
        return decoder.appendTo(builder);
    }

    public static final class OutboundRecordingsEncoder {
        public static final int HEADER_SIZE = 3;
        private final PreviousRecordingEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        OutboundRecordingsEncoder(PreviousRecordingEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)12, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public OutboundRecordingsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + OutboundRecordingsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 12;
        }

        public static int recordingIdId() {
            return 11;
        }

        public static int recordingIdSinceVersion() {
            return 0;
        }

        public static int recordingIdEncodingOffset() {
            return 0;
        }

        public static int recordingIdEncodingLength() {
            return 8;
        }

        public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long recordingIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long recordingIdMinValue() {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public OutboundRecordingsEncoder recordingId(long value) {
            this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static int libraryIdId() {
            return 13;
        }

        public static int libraryIdSinceVersion() {
            return 10;
        }

        public static int libraryIdEncodingOffset() {
            return 8;
        }

        public static int libraryIdEncodingLength() {
            return 4;
        }

        public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int libraryIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int libraryIdMinValue() {
            return -2147483647;
        }

        public static int libraryIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public OutboundRecordingsEncoder libraryId(int value) {
            this.buffer.putInt(this.offset + 8, value, BYTE_ORDER);
            return this;
        }
    }

    public static final class InboundRecordingsEncoder {
        public static final int HEADER_SIZE = 3;
        private final PreviousRecordingEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        InboundRecordingsEncoder(PreviousRecordingEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)12, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public InboundRecordingsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + InboundRecordingsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 12;
        }

        public static int recordingIdId() {
            return 10;
        }

        public static int recordingIdSinceVersion() {
            return 0;
        }

        public static int recordingIdEncodingOffset() {
            return 0;
        }

        public static int recordingIdEncodingLength() {
            return 8;
        }

        public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long recordingIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long recordingIdMinValue() {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public InboundRecordingsEncoder recordingId(long value) {
            this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static int libraryIdId() {
            return 12;
        }

        public static int libraryIdSinceVersion() {
            return 10;
        }

        public static int libraryIdEncodingOffset() {
            return 8;
        }

        public static int libraryIdEncodingLength() {
            return 4;
        }

        public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int libraryIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int libraryIdMinValue() {
            return -2147483647;
        }

        public static int libraryIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public InboundRecordingsEncoder libraryId(int value) {
            this.buffer.putInt(this.offset + 8, value, BYTE_ORDER);
            return this;
        }
    }
}

