/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.ir;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.agrona.LangUtil;
import org.agrona.Verify;
import org.agrona.generation.ResourceConsumer;
import uk.co.real_logic.artio.dictionary.ir.AnyFields;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;

public final class Entry {
    public static final Comparator<Entry> BY_NAME = Comparator.comparing(Entry::name);
    private boolean required;
    private Element element;
    private boolean isInParent;
    private List<Entry> sharedChildEntries;

    public static Entry required(Element element) {
        return new Entry(true, element);
    }

    public static Entry optional(Element element) {
        return new Entry(false, element);
    }

    public <T> T match(BiFunction<Entry, Field, ? extends T> withField, BiFunction<Entry, Group, ? extends T> withGroup, BiFunction<Entry, Component, ? extends T> withComponent, BiFunction<Entry, AnyFields, ? extends T> withAnyFields) {
        if (this.element instanceof Field) {
            return withField.apply(this, (Field)this.element);
        }
        if (this.element instanceof Group) {
            return withGroup.apply(this, (Group)this.element);
        }
        if (this.element instanceof Component) {
            return withComponent.apply(this, (Component)this.element);
        }
        if (this.element instanceof AnyFields) {
            return withAnyFields.apply(this, (AnyFields)this.element);
        }
        throw new IllegalStateException("Unknown element type: " + this.element);
    }

    public void forEach(ResourceConsumer<Field> withField, ResourceConsumer<Group> withGroup, ResourceConsumer<Component> withComponent, ResourceConsumer<AnyFields> withAnyFields) {
        block6: {
            try {
                if (this.element instanceof Field) {
                    withField.accept((Object)((Field)this.element));
                    break block6;
                }
                if (this.element instanceof Group) {
                    withGroup.accept((Object)((Group)this.element));
                    break block6;
                }
                if (this.element instanceof Component) {
                    withComponent.accept((Object)((Component)this.element));
                    break block6;
                }
                if (this.element instanceof AnyFields) {
                    withAnyFields.accept((Object)((AnyFields)this.element));
                    break block6;
                }
                throw new IllegalStateException("Unknown element type: " + this.element);
            }
            catch (IOException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
    }

    public <T> T matchEntry(Function<Entry, ? extends T> withField, Function<Entry, ? extends T> withGroup, Function<Entry, ? extends T> withComponent, Function<Entry, ? extends T> withAnyFields) {
        return (T)this.match((entry, field) -> withField.apply((Entry)entry), (entry, group) -> withGroup.apply((Entry)entry), (entry, component) -> withComponent.apply((Entry)entry), (entry, anyFields) -> withAnyFields.apply((Entry)entry));
    }

    public Entry(boolean required, Element element) {
        this.required = required;
        this.element = element;
    }

    public boolean required() {
        return this.required;
    }

    public void required(boolean required) {
        this.required = required;
    }

    public Element element() {
        return this.element;
    }

    public Entry element(Element element) {
        Verify.notNull((Object)element, (String)"element");
        this.element = element;
        return this;
    }

    public boolean isField() {
        return this.element() instanceof Field;
    }

    public boolean isComponent() {
        return this.element() instanceof Component;
    }

    public boolean isGroup() {
        return this.element() instanceof Group;
    }

    public boolean isAnyFields() {
        return this.element() instanceof AnyFields;
    }

    public String toString() {
        return "Entry{required=" + this.required + ", element=" + this.element + ", isInParent=" + this.isInParent + '}';
    }

    public void sharedChildEntries(List<Entry> sharedChildEntries) {
        this.sharedChildEntries = sharedChildEntries;
    }

    public List<Entry> sharedChildEntries() {
        return this.sharedChildEntries;
    }

    public String name() {
        return this.element().name();
    }

    public int number() {
        return ((Field)this.element()).number();
    }

    public boolean isInParent() {
        return this.isInParent;
    }

    public void isInParent(boolean isInParent) {
        this.isInParent = isInParent;
    }

    public static interface Element {
        default public boolean isEnumField() {
            return this instanceof Field && ((Field)this).isEnum();
        }

        public String name();
    }
}

