/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public final class IndexedPositionDecoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 25;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 11;
    public static final String SEMANTIC_VERSION = "0.1";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final IndexedPositionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 25;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 11;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public IndexedPositionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public IndexedPositionDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (25 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public IndexedPositionDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int streamIdId() {
        return 1;
    }

    public static int streamIdSinceVersion() {
        return 0;
    }

    public static int streamIdEncodingOffset() {
        return 0;
    }

    public static int streamIdEncodingLength() {
        return 4;
    }

    public static String streamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int streamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int streamIdMinValue() {
        return -2147483647;
    }

    public static int streamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionIdId() {
        return 2;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 4;
    }

    public static int sessionIdEncodingLength() {
        return 4;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sessionIdMinValue() {
        return -2147483647;
    }

    public static int sessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int recordingIdId() {
        return 4;
    }

    public static int recordingIdSinceVersion() {
        return 0;
    }

    public static int recordingIdEncodingOffset() {
        return 8;
    }

    public static int recordingIdEncodingLength() {
        return 8;
    }

    public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long recordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long recordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long recordingId() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int positionId() {
        return 3;
    }

    public static int positionSinceVersion() {
        return 0;
    }

    public static int positionEncodingOffset() {
        return 16;
    }

    public static int positionEncodingLength() {
        return 8;
    }

    public static String positionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long positionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long positionMinValue() {
        return -9223372036854775807L;
    }

    public static long positionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long position() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        IndexedPositionDecoder decoder = new IndexedPositionDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[IndexedPosition](sbeTemplateId=");
        builder.append(25);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 11) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(11);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 24) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(24);
        builder.append("):");
        builder.append("streamId=");
        builder.append(this.streamId());
        builder.append('|');
        builder.append("sessionId=");
        builder.append(this.sessionId());
        builder.append('|');
        builder.append("recordingId=");
        builder.append(this.recordingId());
        builder.append('|');
        builder.append("position=");
        builder.append(this.position());
        this.limit(originalLimit);
        return builder;
    }

    public IndexedPositionDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

