/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.fields.UtcDateOnlyDecoder;
import uk.co.real_logic.artio.fields.UtcTimeOnlyDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class UtcTimestampDecoder {
    public static final long MIN_EPOCH_MILLIS = -62135596800000L;
    public static final long MAX_EPOCH_MILLIS = 253402300799999L;
    public static final long MIN_EPOCH_MICROS = -62135596800000000L;
    public static final long MAX_EPOCH_MICROS = 253402300799999999L;
    public static final long MIN_EPOCH_NANOS = Long.MIN_VALUE;
    public static final long MAX_EPOCH_NANOS = Long.MAX_VALUE;
    public static final int LENGTH_WITHOUT_MILLISECONDS = 17;
    public static final int LENGTH_WITH_MILLISECONDS = 21;
    public static final int LENGTH_WITH_MICROSECONDS = 24;
    public static final int LENGTH_WITH_NANOSECONDS = 27;
    private static final int TIME_OFFSET = 9;
    private final AsciiBuffer buffer = new MutableAsciiBuffer();
    private final boolean strict;

    public UtcTimestampDecoder(boolean strict) {
        this.strict = strict;
    }

    public long decode(byte[] bytes, int length) {
        this.buffer.wrap(bytes);
        return UtcTimestampDecoder.decode(this.buffer, 0, length, this.strict);
    }

    public long decode(byte[] bytes) {
        return this.decode(bytes, bytes.length);
    }

    public long decodeMicros(byte[] bytes, int length) {
        this.buffer.wrap(bytes);
        return UtcTimestampDecoder.decodeMicros(this.buffer, 0, length, this.strict);
    }

    public long decodeMicros(byte[] bytes) {
        return this.decodeMicros(bytes, bytes.length);
    }

    public long decodeNanos(byte[] bytes, int length) {
        this.buffer.wrap(bytes);
        return UtcTimestampDecoder.decodeNanos(this.buffer, 0, length, this.strict);
    }

    public long decodeNanos(byte[] bytes) {
        return this.decodeNanos(bytes, bytes.length);
    }

    public static long decode(AsciiBuffer timestamp, int offset, int length, boolean strict) {
        long epochDay = UtcDateOnlyDecoder.decode(timestamp, offset);
        long millisecondOfDay = UtcTimeOnlyDecoder.decode(timestamp, offset + 9, length - 9, strict);
        return epochDay * 86400000L + millisecondOfDay;
    }

    public static long decodeMicros(AsciiBuffer timestamp, int offset, int length, boolean strict) {
        long epochDay = UtcDateOnlyDecoder.decode(timestamp, offset);
        long microsOfDay = UtcTimeOnlyDecoder.decodeMicros(timestamp, offset + 9, length - 9, strict);
        return epochDay * 86400000000L + microsOfDay;
    }

    public static long decodeNanos(AsciiBuffer timestamp, int offset, int length, boolean strict) {
        long epochDay = UtcDateOnlyDecoder.decode(timestamp, offset);
        long nanosOfDay = UtcTimeOnlyDecoder.decodeNanos(timestamp, offset + 9, length - 9, strict);
        return epochDay * 86400000000000L + nanosOfDay;
    }
}

