/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.agrona.collections.Int2ObjectHashMap;
import uk.co.real_logic.artio.dictionary.DictionaryParser;
import uk.co.real_logic.artio.dictionary.ir.BaseType;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Field;

public class CodecCollisionFinder {
    private static final boolean PRINT_FIELD_TYPE_COLL = false;
    private static final boolean PRINT_FIELD_TYPE_COLL_IF_FIXABLE = false;
    private static final boolean PRINT_FIELD_NUMBER_COLL = false;
    private static final boolean PRINT_ENUM_NON_ENUM_COLL = false;
    private static final boolean PRINT_ENUM_VALUE_COLL = false;
    private static final boolean PRINT_COMPONENT_GROUP_COLL = true;
    private static PrintStream out;

    public static void main(String[] args) throws Exception {
        out = new PrintStream(new FileOutputStream("out.txt"));
        File dir = new File(args[0]);
        File[] dictionaryFiles = dir.listFiles((ignore, name) -> name.endsWith(".xml"));
        DictionaryParser parser = new DictionaryParser(true);
        HashMap<File, Dictionary> fileToDictionary = new HashMap<File, Dictionary>();
        for (File dictionaryXmlFile : dictionaryFiles) {
            out.println("Parsing " + dictionaryXmlFile.getName());
            try (FileInputStream in = new FileInputStream(dictionaryXmlFile);){
                Dictionary dictionary = parser.parse(in, null);
                fileToDictionary.put(dictionaryXmlFile, dictionary);
            }
        }
        out.println("Analyzing Dictionaries ... ");
        CodecCollisionFinder.findFieldCollisions(fileToDictionary);
        CodecCollisionFinder.findComponentGroupCollisions(fileToDictionary);
    }

    private static void findComponentGroupCollisions(Map<File, Dictionary> fileToDictionary) {
        HashSet<String> groupNames = new HashSet<String>();
        HashSet<String> messageNames = new HashSet<String>();
        HashSet<String> componentNames = new HashSet<String>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Map.Entry<File, Dictionary> pair : fileToDictionary.entrySet()) {
            Dictionary dictionary = pair.getValue();
            dictionary.messages().forEach(msg -> {
                messageNames.add(msg.name());
                msg.allGroupsIncludingComponents().forEach(group -> groupNames.add(group.name()));
            });
            fieldNames.addAll(dictionary.fields().keySet());
            dictionary.components().values().forEach(msg -> componentNames.add(msg.name()));
        }
        out.println("Components & Groups: " + CodecCollisionFinder.intersection(componentNames, groupNames));
        out.println("Components & Messages: " + CodecCollisionFinder.intersection(componentNames, messageNames));
        out.println("Messages & Groups: " + CodecCollisionFinder.intersection(messageNames, groupNames));
        out.println("Fields & Groups: " + CodecCollisionFinder.intersection(fieldNames, groupNames));
        out.println("Fields & Components: " + CodecCollisionFinder.intersection(fieldNames, componentNames));
    }

    private static Set<String> intersection(Set<String> left, Set<String> right) {
        HashSet<String> commonNames = new HashSet<String>(left);
        commonNames.retainAll(right);
        return commonNames;
    }

    private static void findFieldCollisions(Map<File, Dictionary> fileToDictionary) {
        HashMap<String, Field> allFields = new HashMap<String, Field>();
        Int2ObjectHashMap numberToField = new Int2ObjectHashMap();
        for (Map.Entry<File, Dictionary> pair : fileToDictionary.entrySet()) {
            File file = pair.getKey();
            Dictionary dictionary = pair.getValue();
            Map<String, Field> fields = dictionary.fields();
            for (Field field : fields.values()) {
                CodecCollisionFinder.checkNumberCollisions((Int2ObjectHashMap<Map<String, Integer>>)numberToField, field);
                String name = field.name();
                Field oldField = (Field)allFields.get(name);
                if (oldField == null) {
                    allFields.put(name, field);
                    continue;
                }
                int number = field.number();
                boolean isEnum = field.isEnum();
                boolean oldEnum = oldField.isEnum();
                Field.Type type = field.type();
                Field.Type oldType = oldField.type();
                BaseType baseType = BaseType.from(type);
                BaseType baseType2 = BaseType.from(oldType);
            }
        }
        CodecCollisionFinder.printNumberCollisions((Int2ObjectHashMap<Map<String, Integer>>)numberToField);
    }

    private static void printNumberCollisions(Int2ObjectHashMap<Map<String, Integer>> numberToField) {
    }

    private static void checkNumberCollisions(Int2ObjectHashMap<Map<String, Integer>> numberToField, Field field) {
    }

    private static boolean canCombine(BaseType baseType, BaseType baseType2) {
        return CodecCollisionFinder.canCombineOrdered(baseType, baseType2) || CodecCollisionFinder.canCombineOrdered(baseType2, baseType);
    }

    private static boolean canCombineOrdered(BaseType baseType, BaseType baseType2) {
        boolean string2 = baseType2 == BaseType.STRING;
        boolean int1 = baseType == BaseType.INT;
        boolean char1 = baseType == BaseType.CHAR;
        return char1 && string2 || int1 && string2 || baseType == BaseType.TIMESTAMP && string2 || baseType == BaseType.FLOAT && string2 || int1 && baseType2 == BaseType.CHAR || char1 && baseType2 == BaseType.BOOLEAN;
    }

    private static /* synthetic */ void lambda$printNumberCollisions$5(Integer number, Map nameToCount) {
        if (nameToCount.size() > 1) {
            out.println("number = " + number);
            nameToCount.forEach((name, count) -> out.println("name = " + name + ", count = " + count));
        }
    }
}

