/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.SeqIndexSyncDecoder;

public final class SeqIndexSyncEncoder {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 74;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 22;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SeqIndexSyncEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 74;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 22;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SeqIndexSyncEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 16);
        return this;
    }

    public SeqIndexSyncEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(16).templateId(74).schemaId(666).version(22);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public SeqIndexSyncEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionIdId() {
        return 2;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 4;
    }

    public static int sessionIdEncodingLength() {
        return 8;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SeqIndexSyncEncoder sessionId(long value) {
        this.buffer.putLong(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sequenceIndexId() {
        return 3;
    }

    public static int sequenceIndexSinceVersion() {
        return 0;
    }

    public static int sequenceIndexEncodingOffset() {
        return 12;
    }

    public static int sequenceIndexEncodingLength() {
        return 4;
    }

    public static String sequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceIndexMinValue() {
        return -2147483647;
    }

    public static int sequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public SeqIndexSyncEncoder sequenceIndex(int value) {
        this.buffer.putInt(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SeqIndexSyncDecoder decoder = new SeqIndexSyncDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 16, 22);
        return decoder.appendTo(builder);
    }
}

