/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.InboundFixPConnectDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class InboundFixPConnectEncoder {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 67;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 22;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final InboundFixPConnectEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 67;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 22;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public InboundFixPConnectEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 20);
        return this;
    }

    public InboundFixPConnectEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(20).templateId(67).schemaId(666).version(22);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int connectionId() {
        return 1;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 0;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public InboundFixPConnectEncoder connection(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionIdId() {
        return 2;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 8;
    }

    public static int sessionIdEncodingLength() {
        return 8;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIdNullValue() {
        return -1L;
    }

    public static long sessionIdMinValue() {
        return 0L;
    }

    public static long sessionIdMaxValue() {
        return -2L;
    }

    public InboundFixPConnectEncoder sessionId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int protocolTypeId() {
        return 3;
    }

    public static int protocolTypeSinceVersion() {
        return 16;
    }

    public static int protocolTypeEncodingOffset() {
        return 16;
    }

    public static int protocolTypeEncodingLength() {
        return 2;
    }

    public static String protocolTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public InboundFixPConnectEncoder protocolType(FixPProtocolType value) {
        this.buffer.putShort(this.offset + 16, (short)value.value(), ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int messageLengthId() {
        return 7;
    }

    public static int messageLengthSinceVersion() {
        return 0;
    }

    public static int messageLengthEncodingOffset() {
        return 18;
    }

    public static int messageLengthEncodingLength() {
        return 2;
    }

    public static String messageLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int messageLengthNullValue() {
        return 65535;
    }

    public static int messageLengthMinValue() {
        return 0;
    }

    public static int messageLengthMaxValue() {
        return 65534;
    }

    public InboundFixPConnectEncoder messageLength(int value) {
        this.buffer.putShort(this.offset + 18, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        InboundFixPConnectDecoder decoder = new InboundFixPConnectDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 20, 22);
        return decoder.appendTo(builder);
    }
}

