/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.fields.CalendricalUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class UtcDateOnlyEncoder {
    public static final int LENGTH = 8;
    public static final int MIN_EPOCH_DAYS = -719162;
    public static final int MAX_EPOCH_DAYS = 2932896;
    private final MutableAsciiBuffer buffer = new MutableAsciiBuffer();

    public int encode(int epochDays, byte[] bytes) {
        this.buffer.wrap(bytes);
        return UtcDateOnlyEncoder.encode(epochDays, this.buffer, 0);
    }

    public static int encode(int epochDays, MutableAsciiBuffer string, int offset) {
        if (epochDays < -719162 || epochDays > 2932896) {
            throw new IllegalArgumentException(epochDays + " is outside of the valid range for this encoder");
        }
        CalendricalUtil.encodeDate(epochDays, string, offset);
        return 8;
    }
}

