/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.EstablishAckEncoder;
import b3.entrypoint.fixp.sbe.EstablishRejectCode;
import b3.entrypoint.fixp.sbe.EstablishRejectEncoder;
import b3.entrypoint.fixp.sbe.FinishedReceivingEncoder;
import b3.entrypoint.fixp.sbe.FinishedSendingEncoder;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.NegotiateRejectEncoder;
import b3.entrypoint.fixp.sbe.NegotiateResponseEncoder;
import b3.entrypoint.fixp.sbe.NegotiationRejectCode;
import b3.entrypoint.fixp.sbe.NotAppliedEncoder;
import b3.entrypoint.fixp.sbe.RetransmissionEncoder;
import b3.entrypoint.fixp.sbe.RetransmitRejectCode;
import b3.entrypoint.fixp.sbe.RetransmitRejectEncoder;
import b3.entrypoint.fixp.sbe.SequenceEncoder;
import b3.entrypoint.fixp.sbe.TerminateEncoder;
import b3.entrypoint.fixp.sbe.TerminationCode;
import io.aeron.ExclusivePublication;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointContext;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FirstMessageRejectReason;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;

public class BinaryEntryPointProxy
extends AbstractFixPProxy {
    public static final int BINARY_ENTRYPOINT_HEADER_LENGTH = 12;
    private static final int BINARY_ENTRYPOINT_MESSAGE_HEADER = 44;
    private static final int NEGOTIATE_REJECT_LENGTH = 37;
    private static final int ESTABLISH_REJECT_LENGTH = 33;
    private final MessageHeaderEncoder beMessageHeader = new MessageHeaderEncoder();
    private final NegotiateResponseEncoder negotiateResponse = new NegotiateResponseEncoder();
    private final NegotiateRejectEncoder negotiateReject = new NegotiateRejectEncoder();
    private final EstablishAckEncoder establishAck = new EstablishAckEncoder();
    private final EstablishRejectEncoder establishReject = new EstablishRejectEncoder();
    private final SequenceEncoder sequence = new SequenceEncoder();
    private final TerminateEncoder terminate = new TerminateEncoder();
    private final FinishedReceivingEncoder finishedReceiving = new FinishedReceivingEncoder();
    private final FinishedSendingEncoder finishedSending = new FinishedSendingEncoder();
    private final NotAppliedEncoder notApplied = new NotAppliedEncoder();
    private final RetransmissionEncoder retransmission = new RetransmissionEncoder();
    private final RetransmitRejectEncoder retransmitReject = new RetransmitRejectEncoder();
    private final Consumer<StringBuilder> negotiateResponseAppendTo = arg_0 -> ((NegotiateResponseEncoder)this.negotiateResponse).appendTo(arg_0);
    private final Consumer<StringBuilder> negotiateRejectAppendTo = arg_0 -> ((NegotiateRejectEncoder)this.negotiateReject).appendTo(arg_0);
    private final Consumer<StringBuilder> establishAckAppendTo = arg_0 -> ((EstablishAckEncoder)this.establishAck).appendTo(arg_0);
    private final Consumer<StringBuilder> establishRejectAppendTo = arg_0 -> ((EstablishRejectEncoder)this.establishReject).appendTo(arg_0);
    private final Consumer<StringBuilder> terminateAppendTo = arg_0 -> ((TerminateEncoder)this.terminate).appendTo(arg_0);
    private final Consumer<StringBuilder> sequenceAppendTo = arg_0 -> ((SequenceEncoder)this.sequence).appendTo(arg_0);
    private final Consumer<StringBuilder> finishedReceivingAppendTo = arg_0 -> ((FinishedReceivingEncoder)this.finishedReceiving).appendTo(arg_0);
    private final Consumer<StringBuilder> finishedSendingAppendTo = arg_0 -> ((FinishedSendingEncoder)this.finishedSending).appendTo(arg_0);
    private final Consumer<StringBuilder> notAppliedAppendTo = arg_0 -> ((NotAppliedEncoder)this.notApplied).appendTo(arg_0);
    private final Consumer<StringBuilder> retransmissionAppendTo = arg_0 -> ((RetransmissionEncoder)this.retransmission).appendTo(arg_0);
    private final Consumer<StringBuilder> retransmitRejectAppendTo = arg_0 -> ((RetransmitRejectEncoder)this.retransmitReject).appendTo(arg_0);
    private final UnsafeBuffer buffer = new UnsafeBuffer();
    private final EpochNanoClock clock;

    public BinaryEntryPointProxy(long connectionId, ExclusivePublication publication, EpochNanoClock clock) {
        super(connectionId, publication);
        this.clock = clock;
    }

    public long sendSequence(long sessionId, long nextSentSeqNo) {
        SequenceEncoder sequence = this.sequence;
        long position = this.claimMessage(4, (MessageEncoderFlyweight)sequence, this.clock.nanoTime());
        if (position < 0L) {
            return position;
        }
        sequence.nextSeqNo(nextSentSeqNo);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.sequenceAppendTo);
        this.commit();
        return position;
    }

    public long sendNegotiateResponse(long sessionID, long sessionVerID, long requestTimestamp, long enteringFirm) {
        NegotiateResponseEncoder negotiateResponse = this.negotiateResponse;
        long position = this.claimMessage(24, (MessageEncoderFlyweight)negotiateResponse, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        negotiateResponse.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        negotiateResponse.enteringFirm(enteringFirm);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.negotiateResponseAppendTo);
        this.commit();
        return position;
    }

    public long sendEstablishAck(long sessionID, long sessionVerID, long requestTimestamp, long keepAliveInterval, long nextSeqNo, long lastIncomingSeqNo) {
        EstablishAckEncoder establishAck = this.establishAck;
        long position = this.claimMessage(36, (MessageEncoderFlyweight)establishAck, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        establishAck.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        establishAck.keepAliveInterval().time(keepAliveInterval);
        establishAck.nextSeqNo(nextSeqNo).lastIncomingSeqNo(lastIncomingSeqNo);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.establishAckAppendTo);
        this.commit();
        return position;
    }

    public long sendEstablishReject(long sessionID, long sessionVerID, long requestTimestamp, EstablishRejectCode establishmentRejectCode) {
        EstablishRejectEncoder establishReject = this.establishReject;
        long position = this.claimMessage(21, (MessageEncoderFlyweight)establishReject, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        establishReject.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        establishReject.establishmentRejectCode(establishmentRejectCode);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.establishRejectAppendTo);
        this.commit();
        return position;
    }

    public long sendTerminate(long sessionId, long sessionVerId, TerminationCode terminationCode, long timestampInNs) {
        TerminateEncoder terminate = this.terminate;
        long position = this.claimMessage(13, (MessageEncoderFlyweight)terminate, timestampInNs);
        if (position < 0L) {
            return position;
        }
        terminate.sessionID(sessionId).sessionVerID(sessionVerId).terminationCode(terminationCode);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.terminateAppendTo);
        this.commit();
        return position;
    }

    public long sendFinishedReceiving(long sessionID, long sessionVerId, long timestampInNs) {
        FinishedReceivingEncoder finishedReceiving = this.finishedReceiving;
        long position = this.claimMessage(12, (MessageEncoderFlyweight)finishedReceiving, timestampInNs);
        if (position < 0L) {
            return position;
        }
        finishedReceiving.sessionID(sessionID).sessionVerID(sessionVerId);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.finishedReceivingAppendTo);
        this.commit();
        return position;
    }

    public long sendFinishedSending(long sessionId, long sessionVerId, long lastSeqNo, long timestampInNs) {
        FinishedSendingEncoder finishedSending = this.finishedSending;
        long position = this.claimMessage(16, (MessageEncoderFlyweight)finishedSending, timestampInNs);
        if (position < 0L) {
            return position;
        }
        finishedSending.sessionID(sessionId).sessionVerID(sessionVerId).lastSeqNo(lastSeqNo);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.finishedSendingAppendTo);
        this.commit();
        return position;
    }

    public long sendNotApplied(long fromSeqNo, long count, long timestampInNs) {
        NotAppliedEncoder notApplied = this.notApplied;
        long position = this.claimMessage(8, (MessageEncoderFlyweight)notApplied, timestampInNs);
        if (position < 0L) {
            return position;
        }
        notApplied.fromSeqNo(fromSeqNo).count(count);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.notAppliedAppendTo);
        this.commit();
        return position;
    }

    public long sendRetransmission(long nextSeqNo, long count, long internalTimestampInNs, long requestTimestampInNs) {
        RetransmissionEncoder retransmission = this.retransmission;
        long position = this.claimMessage(20, (MessageEncoderFlyweight)retransmission, internalTimestampInNs);
        if (position < 0L) {
            return position;
        }
        retransmission.sessionID(this.sessionId).requestTimestamp().time(requestTimestampInNs);
        retransmission.nextSeqNo(nextSeqNo).count(count);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.retransmissionAppendTo);
        this.commit();
        return position;
    }

    public long sendRetransmitReject(RetransmitRejectCode retransmitRejectCode, long timestampInNs, long requestTimestampInNs) {
        RetransmitRejectEncoder retransmitReject = this.retransmitReject;
        long position = this.claimMessage(13, (MessageEncoderFlyweight)retransmitReject, timestampInNs);
        if (position < 0L) {
            return position;
        }
        retransmitReject.sessionID(this.sessionId).requestTimestamp().time(requestTimestampInNs);
        retransmitReject.retransmitRejectCode(retransmitRejectCode);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.retransmitRejectAppendTo);
        this.commit();
        return position;
    }

    public long claimMessage(int messageLength, MessageEncoderFlyweight message, long timestampInNs) {
        return this.claimMessage(messageLength, message, timestampInNs, 44, 12, (short)-5296);
    }

    protected int applyHeader(MessageEncoderFlyweight message, MutableDirectBuffer buffer, int offset) {
        this.beMessageHeader.wrap(buffer, offset).blockLength(message.sbeBlockLength()).templateId(message.sbeTemplateId()).schemaId(message.sbeSchemaId()).version(message.sbeSchemaVersion());
        return offset + this.beMessageHeader.encodedLength();
    }

    public ByteBuffer encodeReject(FixPContext fixPContext, FirstMessageRejectReason rejectReason) {
        ByteBuffer byteBuffer;
        EstablishRejectCode establishRejectCode;
        NegotiationRejectCode negotiationRejectCode;
        boolean isNegotiate;
        BinaryEntryPointContext identification = (BinaryEntryPointContext)fixPContext;
        switch (rejectReason) {
            case CREDENTIALS: {
                isNegotiate = identification.fromNegotiate();
                negotiationRejectCode = NegotiationRejectCode.CREDENTIALS;
                establishRejectCode = EstablishRejectCode.CREDENTIALS;
                break;
            }
            case NEGOTIATE_DUPLICATE_ID: {
                isNegotiate = true;
                negotiationRejectCode = NegotiationRejectCode.DUPLICATE_ID;
                establishRejectCode = null;
                break;
            }
            case NEGOTIATE_UNSPECIFIED: {
                isNegotiate = true;
                negotiationRejectCode = NegotiationRejectCode.UNSPECIFIED;
                establishRejectCode = null;
                break;
            }
            case ESTABLISH_UNNEGOTIATED: {
                isNegotiate = false;
                negotiationRejectCode = null;
                establishRejectCode = EstablishRejectCode.UNNEGOTIATED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid reject reason: " + rejectReason);
            }
        }
        if (isNegotiate) {
            byteBuffer = ByteBuffer.allocate(37);
            this.buffer.wrap(byteBuffer);
            SimpleOpenFramingHeader.writeSofh((MutableDirectBuffer)this.buffer, (int)0, (int)37, (short)-5296);
            this.negotiateReject.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 4, this.beMessageHeader).sessionID(identification.sessionID()).sessionVerID(identification.sessionVerID()).requestTimestamp().time(identification.requestTimestampInNs());
            this.negotiateReject.enteringFirm(identification.enteringFirm()).negotiationRejectCode(negotiationRejectCode);
            DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.negotiateRejectAppendTo);
        } else {
            byteBuffer = ByteBuffer.allocate(33);
            this.buffer.wrap(byteBuffer);
            SimpleOpenFramingHeader.writeSofh((MutableDirectBuffer)this.buffer, (int)0, (int)33, (short)-5296);
            this.establishReject.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 4, this.beMessageHeader).sessionID(identification.sessionID()).sessionVerID(identification.sessionVerID()).requestTimestamp().time(identification.requestTimestampInNs());
            this.establishReject.establishmentRejectCode(establishRejectCode);
            DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"< ", this.establishRejectAppendTo);
        }
        return byteBuffer;
    }
}

