/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointKey;
import uk.co.real_logic.artio.engine.framer.FixPContexts;
import uk.co.real_logic.artio.fixp.FirstMessageRejectReason;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.messages.FixPProtocolType;

public class BinaryEntryPointContext
implements FixPContext {
    private final long sessionID;
    private final long sessionVerID;
    private final long requestTimestampInNs;
    private final long enteringFirm;
    private boolean ended;
    private final boolean fromNegotiate;
    private FixPContexts contexts;
    private int offset = Integer.MIN_VALUE;
    private final BinaryEntryPointKey key;

    public BinaryEntryPointContext(long sessionID, long sessionVerID, long timestampInNs, long enteringFirm, boolean fromNegotiate) {
        this.sessionID = sessionID;
        this.sessionVerID = sessionVerID;
        this.requestTimestampInNs = timestampInNs;
        this.enteringFirm = enteringFirm;
        this.fromNegotiate = fromNegotiate;
        this.ended = false;
        this.key = new BinaryEntryPointKey(sessionID);
    }

    public long sessionID() {
        return this.sessionID;
    }

    public long sessionVerID() {
        return this.sessionVerID;
    }

    public long requestTimestampInNs() {
        return this.requestTimestampInNs;
    }

    public long enteringFirm() {
        return this.enteringFirm;
    }

    public boolean fromNegotiate() {
        return this.fromNegotiate;
    }

    public String toString() {
        return "BinaryEntryPointContext{sessionID=" + this.sessionID + ", sessionVerID=" + this.sessionVerID + ", requestTimestampInNs=" + this.requestTimestampInNs + ", enteringFirm=" + this.enteringFirm + ", fromNegotiate=" + this.fromNegotiate + '}';
    }

    public BinaryEntryPointKey key() {
        return this.key;
    }

    public FirstMessageRejectReason checkAccept(FixPContext fixPContext) {
        if (fixPContext == null) {
            return this.checkFirstConnect();
        }
        if (!(fixPContext instanceof BinaryEntryPointContext)) {
            throw new IllegalArgumentException("Unable to compare protocol: " + this + " to " + fixPContext);
        }
        BinaryEntryPointContext oldContext = (BinaryEntryPointContext)fixPContext;
        if (this.sessionID != oldContext.sessionID) {
            throw new IllegalArgumentException("Unable to compare: " + this.sessionID + " to " + oldContext.sessionID);
        }
        this.offset = oldContext.offset();
        this.contexts = oldContext.contexts;
        if (this.fromNegotiate) {
            return this.sessionVerID > oldContext.sessionVerID ? null : FirstMessageRejectReason.NEGOTIATE_DUPLICATE_ID;
        }
        if (oldContext.sessionVerID == this.sessionVerID) {
            return oldContext.ended ? FirstMessageRejectReason.ESTABLISH_UNNEGOTIATED : null;
        }
        return FirstMessageRejectReason.ESTABLISH_UNNEGOTIATED;
    }

    public void initiatorReconnect(boolean reestablishConnection) {
        throw new UnsupportedOperationException();
    }

    public FixPProtocolType protocolType() {
        return FixPProtocolType.BINARY_ENTRYPOINT;
    }

    public void onEndSequence() {
        this.ended = true;
        this.contexts.updateContext((FixPContext)this);
    }

    public FirstMessageRejectReason checkFirstConnect() {
        if (!this.fromNegotiate) {
            return FirstMessageRejectReason.ESTABLISH_UNNEGOTIATED;
        }
        return null;
    }

    void offset(int offset) {
        this.offset = offset;
    }

    int offset() {
        return this.offset;
    }

    void contexts(FixPContexts contexts) {
        this.contexts = contexts;
    }

    boolean ended() {
        return this.ended;
    }

    void ended(boolean ended) {
        this.ended = ended;
    }
}

