/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.EstablishDecoder;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.NegotiateDecoder;
import b3.entrypoint.fixp.sbe.SequenceDecoder;
import b3.entrypoint.fixp.sbe.TerminateDecoder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointIdentification;
import uk.co.real_logic.artio.binary_entrypoint.InternalBinaryEntrypointConnection;
import uk.co.real_logic.artio.fixp.AbstractFixPParser;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;

public class BinaryEntryPointParser
extends AbstractFixPParser {
    private final MessageHeaderDecoder header = new MessageHeaderDecoder();
    private final NegotiateDecoder negotiate = new NegotiateDecoder();
    private final EstablishDecoder establish = new EstablishDecoder();
    private final TerminateDecoder terminate = new TerminateDecoder();
    private final SequenceDecoder sequence = new SequenceDecoder();
    private final InternalBinaryEntrypointConnection handler;

    public BinaryEntryPointParser(InternalBinaryEntrypointConnection handler) {
        this.handler = handler;
    }

    public int templateId(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.templateId();
    }

    public int blockLength(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.blockLength();
    }

    public int version(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.version();
    }

    public long onMessage(DirectBuffer buffer, int start) {
        int offset = start + 4;
        this.header.wrap(buffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                return this.onNegotiate(buffer, offset, blockLength, version);
            }
            case 4: {
                return this.onEstablish(buffer, offset, blockLength, version);
            }
            case 7: {
                return this.onTerminate(buffer, offset, blockLength, version);
            }
            case 9: {
                return this.onSequence(buffer, offset, blockLength, version);
            }
        }
        int sofhMessageSize = SimpleOpenFramingHeader.readSofhMessageSize((DirectBuffer)buffer, (int)start);
        return this.handler.onMessage(buffer, offset, templateId, blockLength, version, sofhMessageSize);
    }

    private long onSequence(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.sequence.wrap(buffer, offset, blockLength, version);
        return this.handler.onSequence(this.sequence.nextSeqNo());
    }

    private long onTerminate(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.terminate.wrap(buffer, offset, blockLength, version);
        return this.handler.onTerminate(this.terminate.sessionID(), this.terminate.sessionVerID(), this.terminate.terminationCode());
    }

    private long onEstablish(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.establish.wrap(buffer, offset, blockLength, version);
        return this.handler.onEstablish(this.establish.sessionID(), this.establish.sessionVerID(), this.establish.timestamp().time(), this.establish.keepAliveInterval().time(), this.establish.nextSeqNo(), this.establish.cancelOnDisconnectType(), this.establish.codTimeoutWindow().time());
    }

    private long onNegotiate(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.negotiate.wrap(buffer, offset, blockLength, version);
        return this.handler.onNegotiate(this.negotiate.sessionID(), this.negotiate.sessionVerID(), this.negotiate.timestamp().time(), this.negotiate.enteringFirm(), this.negotiate.onbehalfFirm(), this.negotiate.senderLocation());
    }

    public BinaryEntryPointIdentification lookupIdentification(DirectBuffer messageBuffer, int messageOffset, int messageLength) {
        int offset = messageOffset + 4;
        this.header.wrap(messageBuffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                this.negotiate.wrap(messageBuffer, offset, blockLength, version);
                return new BinaryEntryPointIdentification(this.negotiate.sessionID(), this.negotiate.sessionVerID());
            }
            case 4: {
                this.establish.wrap(messageBuffer, offset, blockLength, version);
                return new BinaryEntryPointIdentification(this.establish.sessionID(), this.establish.sessionVerID());
            }
        }
        throw new IllegalArgumentException("Template id: " + templateId + " isn't a negotiate or establish");
    }

    public long sessionId(DirectBuffer buffer, int start) {
        int offset = start + 4;
        this.header.wrap(buffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                this.negotiate.wrap(buffer, offset, blockLength, version);
                return this.negotiate.sessionID();
            }
            case 4: {
                this.establish.wrap(buffer, offset, blockLength, version);
                return this.establish.sessionID();
            }
        }
        throw new IllegalArgumentException("Template id: " + templateId + " isn't a negotiate or establish");
    }
}

