/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointKey;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointProtocol;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPFirstMessageResponse;
import uk.co.real_logic.artio.messages.FixPProtocolType;

public class BinaryEntryPointContext
implements FixPContext {
    private final long sessionID;
    private final long sessionVerID;
    private final long requestTimestampInNs;
    private final long enteringFirm;
    private boolean ended;
    private final boolean fromNegotiate;
    private final BinaryEntryPointKey key;
    private boolean hasUnsentMessagesAtNegotiate;
    private int offset = Integer.MIN_VALUE;

    public BinaryEntryPointContext(long sessionID, long sessionVerID, long timestampInNs, long enteringFirm, boolean fromNegotiate) {
        this.sessionID = sessionID;
        this.sessionVerID = sessionVerID;
        this.requestTimestampInNs = timestampInNs;
        this.enteringFirm = enteringFirm;
        this.fromNegotiate = fromNegotiate;
        this.ended = false;
        this.hasUnsentMessagesAtNegotiate = sessionVerID == Long.MIN_VALUE;
        this.key = new BinaryEntryPointKey(sessionID);
    }

    public static BinaryEntryPointContext forNextSessionVerID(int sessionId, long nanoTime, int firmId) {
        return new BinaryEntryPointContext(sessionId, Long.MIN_VALUE, nanoTime, firmId, true);
    }

    public long sessionID() {
        return this.sessionID;
    }

    public long sessionVerID() {
        return this.sessionVerID;
    }

    public long requestTimestampInNs() {
        return this.requestTimestampInNs;
    }

    public long enteringFirm() {
        return this.enteringFirm;
    }

    public boolean fromNegotiate() {
        return this.fromNegotiate;
    }

    public BinaryEntryPointKey key() {
        return this.key;
    }

    public FixPFirstMessageResponse checkAccept(FixPContext fixPContext, boolean ignoreFromNegotiate) {
        if (fixPContext == null) {
            if (ignoreFromNegotiate) {
                return FixPFirstMessageResponse.OK;
            }
            return this.checkFirstConnect();
        }
        this.validateType(fixPContext);
        BinaryEntryPointContext oldContext = (BinaryEntryPointContext)fixPContext;
        if (this.sessionID != oldContext.sessionID) {
            throw new IllegalArgumentException("Unable to compare: " + this.sessionID + " to " + oldContext.sessionID);
        }
        this.offset = oldContext.offset();
        if (ignoreFromNegotiate) {
            return oldContext.ended ? FixPFirstMessageResponse.VER_ID_ENDED : FixPFirstMessageResponse.OK;
        }
        long oldSessionVerID = oldContext.sessionVerID;
        if (this.fromNegotiate) {
            if (this.sessionVerID > oldSessionVerID) {
                this.hasUnsentMessagesAtNegotiate = oldSessionVerID == Long.MIN_VALUE;
                return FixPFirstMessageResponse.OK;
            }
            return FixPFirstMessageResponse.NEGOTIATE_DUPLICATE_ID;
        }
        if (oldSessionVerID == this.sessionVerID) {
            return oldContext.ended ? FixPFirstMessageResponse.VER_ID_ENDED : FixPFirstMessageResponse.OK;
        }
        return FixPFirstMessageResponse.ESTABLISH_UNNEGOTIATED;
    }

    private void validateType(FixPContext fixPContext) {
        if (!(fixPContext instanceof BinaryEntryPointContext)) {
            throw new IllegalArgumentException("Unable to compare protocol: " + this + " to " + fixPContext);
        }
    }

    public int compareVersion(FixPContext fixPContext) {
        this.validateType(fixPContext);
        BinaryEntryPointContext oldContext = (BinaryEntryPointContext)fixPContext;
        return Long.compare(this.sessionVerID, oldContext.sessionVerID);
    }

    public void initiatorReconnect(boolean reestablishConnection) {
        BinaryEntryPointProtocol.unsupported();
    }

    public boolean onInitiatorNegotiateResponse() {
        return (Boolean)BinaryEntryPointProtocol.unsupported();
    }

    public void onInitiatorDisconnect() {
        BinaryEntryPointProtocol.unsupported();
    }

    public FixPProtocolType protocolType() {
        return FixPProtocolType.BINARY_ENTRYPOINT;
    }

    public void onEndSequence() {
        this.ended = true;
    }

    public FixPFirstMessageResponse checkFirstConnect() {
        if (!this.fromNegotiate) {
            return FixPFirstMessageResponse.ESTABLISH_UNNEGOTIATED;
        }
        return FixPFirstMessageResponse.OK;
    }

    void offset(int offset) {
        this.offset = offset;
    }

    int offset() {
        return this.offset;
    }

    boolean ended() {
        return this.ended;
    }

    void ended(boolean ended) {
        this.ended = ended;
    }

    public long surrogateSessionId() {
        return this.sessionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryEntryPointContext that = (BinaryEntryPointContext)o;
        if (this.sessionID != that.sessionID) {
            return false;
        }
        if (this.sessionVerID != that.sessionVerID) {
            return false;
        }
        if (this.requestTimestampInNs != that.requestTimestampInNs) {
            return false;
        }
        return this.enteringFirm == that.enteringFirm;
    }

    public int hashCode() {
        int result = (int)(this.sessionID ^ this.sessionID >>> 32);
        result = 31 * result + (int)(this.sessionVerID ^ this.sessionVerID >>> 32);
        result = 31 * result + (int)(this.requestTimestampInNs ^ this.requestTimestampInNs >>> 32);
        result = 31 * result + (int)(this.enteringFirm ^ this.enteringFirm >>> 32);
        return result;
    }

    public String toString() {
        return "BinaryEntryPointContext{sessionID=" + this.sessionID + ", sessionVerID=" + this.sessionVerID + ", requestTimestampInNs=" + this.requestTimestampInNs + ", enteringFirm=" + this.enteringFirm + ", fromNegotiate=" + this.fromNegotiate + '}';
    }

    public boolean hasUnsentMessagesAtNegotiate() {
        return this.hasUnsentMessagesAtNegotiate;
    }
}

