/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.Boolean;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.NewOrderCrossDecoder;
import b3.entrypoint.fixp.sbe.PriceOptionalEncoder;
import b3.entrypoint.fixp.sbe.Side;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class NewOrderCrossEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 56;
    public static final int TEMPLATE_ID = 106;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NewOrderCrossEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final PriceOptionalEncoder price = new PriceOptionalEncoder();
    private final NoSidesEncoder noSides = new NoSidesEncoder(this);

    public int sbeBlockLength() {
        return 56;
    }

    public int sbeTemplateId() {
        return 106;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NewOrderCrossEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 56);
        return this;
    }

    public NewOrderCrossEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(56).templateId(106).schemaId(1).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int crossIDId() {
        return 548;
    }

    public static int crossIDSinceVersion() {
        return 0;
    }

    public static int crossIDEncodingOffset() {
        return 0;
    }

    public static int crossIDEncodingLength() {
        return 8;
    }

    public static String crossIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long crossIDNullValue() {
        return -1L;
    }

    public static long crossIDMinValue() {
        return 0L;
    }

    public static long crossIDMaxValue() {
        return -2L;
    }

    public NewOrderCrossEncoder crossID(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 8;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public NewOrderCrossEncoder securityID(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 16;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 16;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int priceId() {
        return 44;
    }

    public static int priceSinceVersion() {
        return 0;
    }

    public static int priceEncodingOffset() {
        return 16;
    }

    public static int priceEncodingLength() {
        return 8;
    }

    public static String priceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public PriceOptionalEncoder price() {
        this.price.wrap(this.buffer, this.offset + 16);
        return this.price;
    }

    public static int orderQtyId() {
        return 38;
    }

    public static int orderQtySinceVersion() {
        return 0;
    }

    public static int orderQtyEncodingOffset() {
        return 24;
    }

    public static int orderQtyEncodingLength() {
        return 8;
    }

    public static String orderQtyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long orderQtyNullValue() {
        return -1L;
    }

    public static long orderQtyMinValue() {
        return 0L;
    }

    public static long orderQtyMaxValue() {
        return -2L;
    }

    public NewOrderCrossEncoder orderQty(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 32;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public NewOrderCrossEncoder senderLocation(int index, byte value) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 32 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String senderLocationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public NewOrderCrossEncoder putSenderLocation(byte[] src, int srcOffset) {
        int length = 10;
        if (srcOffset < 0 || srcOffset > src.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 32, src, srcOffset, 10);
        return this;
    }

    public NewOrderCrossEncoder senderLocation(String src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 32, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 32 + start, (byte)0);
        }
        return this;
    }

    public NewOrderCrossEncoder senderLocation(CharSequence src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 32, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 32 + start, (byte)0);
        }
        return this;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 42;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public NewOrderCrossEncoder enteringTrader(int index, byte value) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 42 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public NewOrderCrossEncoder putEnteringTrader(byte[] src, int srcOffset) {
        int length = 5;
        if (srcOffset < 0 || srcOffset > src.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 42, src, srcOffset, 5);
        return this;
    }

    public NewOrderCrossEncoder enteringTrader(String src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 42, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 42 + start, (byte)0);
        }
        return this;
    }

    public NewOrderCrossEncoder enteringTrader(CharSequence src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 42, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 42 + start, (byte)0);
        }
        return this;
    }

    public static int marketSegmentIDId() {
        return 1300;
    }

    public static int marketSegmentIDSinceVersion() {
        return 0;
    }

    public static int marketSegmentIDEncodingOffset() {
        return 47;
    }

    public static int marketSegmentIDEncodingLength() {
        return 1;
    }

    public static String marketSegmentIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short marketSegmentIDNullValue() {
        return 255;
    }

    public static short marketSegmentIDMinValue() {
        return 0;
    }

    public static short marketSegmentIDMaxValue() {
        return 254;
    }

    public NewOrderCrossEncoder marketSegmentID(short value) {
        this.buffer.putByte(this.offset + 47, (byte)value);
        return this;
    }

    public static int externalRFQIndicatorId() {
        return 35551;
    }

    public static int externalRFQIndicatorSinceVersion() {
        return 0;
    }

    public static int externalRFQIndicatorEncodingOffset() {
        return 55;
    }

    public static int externalRFQIndicatorEncodingLength() {
        return 1;
    }

    public static String externalRFQIndicatorMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public NewOrderCrossEncoder externalRFQIndicator(Boolean value) {
        this.buffer.putByte(this.offset + 55, (byte)value.value());
        return this;
    }

    public static long noSidesId() {
        return 552L;
    }

    public NoSidesEncoder noSidesCount(int count) {
        this.noSides.wrap(this.buffer, count);
        return this.noSides;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        NewOrderCrossDecoder decoder = new NewOrderCrossDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 56, 5);
        return decoder.appendTo(builder);
    }

    public static final class NoSidesEncoder {
        public static final int HEADER_SIZE = 3;
        private final NewOrderCrossEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NoSidesEncoder(NewOrderCrossEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)18, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NoSidesEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NoSidesEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 18;
        }

        public static int sideId() {
            return 54;
        }

        public static int sideSinceVersion() {
            return 0;
        }

        public static int sideEncodingOffset() {
            return 0;
        }

        public static int sideEncodingLength() {
            return 1;
        }

        public static String sideMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public NoSidesEncoder side(Side value) {
            this.buffer.putByte(this.offset + 0, value.value());
            return this;
        }

        public static int accountId() {
            return 1;
        }

        public static int accountSinceVersion() {
            return 0;
        }

        public static int accountEncodingOffset() {
            return 2;
        }

        public static int accountEncodingLength() {
            return 4;
        }

        public static String accountMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "optional";
            }
            return "";
        }

        public static long accountNullValue() {
            return 0L;
        }

        public static long accountMinValue() {
            return 0L;
        }

        public static long accountMaxValue() {
            return 0xFFFFFFFEL;
        }

        public NoSidesEncoder account(long value) {
            this.buffer.putInt(this.offset + 2, (int)value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int enteringFirmId() {
            return 35501;
        }

        public static int enteringFirmSinceVersion() {
            return 0;
        }

        public static int enteringFirmEncodingOffset() {
            return 6;
        }

        public static int enteringFirmEncodingLength() {
            return 4;
        }

        public static String enteringFirmMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "optional";
            }
            return "";
        }

        public static long enteringFirmNullValue() {
            return 0L;
        }

        public static long enteringFirmMinValue() {
            return 0L;
        }

        public static long enteringFirmMaxValue() {
            return 0xFFFFFFFEL;
        }

        public NoSidesEncoder enteringFirm(long value) {
            this.buffer.putInt(this.offset + 6, (int)value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int clOrdIDId() {
            return 11;
        }

        public static int clOrdIDSinceVersion() {
            return 0;
        }

        public static int clOrdIDEncodingOffset() {
            return 10;
        }

        public static int clOrdIDEncodingLength() {
            return 8;
        }

        public static String clOrdIDMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long clOrdIDNullValue() {
            return -1L;
        }

        public static long clOrdIDMinValue() {
            return 0L;
        }

        public static long clOrdIDMaxValue() {
            return -2L;
        }

        public NoSidesEncoder clOrdID(long value) {
            this.buffer.putLong(this.offset + 10, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }
}

