/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.FlowType;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class NegotiateDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NegotiateDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final UTCTimestampNanosDecoder timestamp = new UTCTimestampNanosDecoder();

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NegotiateDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public NegotiateDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (1 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public NegotiateDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.Negotiate.value();
    }

    public MessageType messageType() {
        return MessageType.Negotiate;
    }

    public static int sessionIDId() {
        return 35518;
    }

    public static int sessionIDSinceVersion() {
        return 0;
    }

    public static int sessionIDEncodingOffset() {
        return 0;
    }

    public static int sessionIDEncodingLength() {
        return 4;
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIDNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long sessionIDMinValue() {
        return 0L;
    }

    public static long sessionIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long sessionID() {
        return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int sessionVerIDId() {
        return 35519;
    }

    public static int sessionVerIDSinceVersion() {
        return 0;
    }

    public static int sessionVerIDEncodingOffset() {
        return 4;
    }

    public static int sessionVerIDEncodingLength() {
        return 8;
    }

    public static String sessionVerIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionVerIDNullValue() {
        return -1L;
    }

    public static long sessionVerIDMinValue() {
        return 0L;
    }

    public static long sessionVerIDMaxValue() {
        return -2L;
    }

    public long sessionVerID() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int timestampId() {
        return 35520;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 12;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosDecoder timestamp() {
        this.timestamp.wrap(this.buffer, this.offset + 12);
        return this.timestamp;
    }

    public static int clientFlowId() {
        return 35516;
    }

    public static int clientFlowSinceVersion() {
        return 0;
    }

    public static int clientFlowEncodingOffset() {
        return 20;
    }

    public static int clientFlowEncodingLength() {
        return 1;
    }

    public static String clientFlowMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short clientFlowRaw() {
        return FlowType.IDEMPOTENT.value();
    }

    public FlowType clientFlow() {
        return FlowType.IDEMPOTENT;
    }

    public static int enteringFirmId() {
        return 35501;
    }

    public static int enteringFirmSinceVersion() {
        return 0;
    }

    public static int enteringFirmEncodingOffset() {
        return 20;
    }

    public static int enteringFirmEncodingLength() {
        return 4;
    }

    public static String enteringFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long enteringFirmNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long enteringFirmMinValue() {
        return 0L;
    }

    public static long enteringFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long enteringFirm() {
        return (long)this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int onbehalfFirmId() {
        return 35517;
    }

    public static int onbehalfFirmSinceVersion() {
        return 0;
    }

    public static int onbehalfFirmEncodingOffset() {
        return 24;
    }

    public static int onbehalfFirmEncodingLength() {
        return 4;
    }

    public static String onbehalfFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long onbehalfFirmNullValue() {
        return 0L;
    }

    public static long onbehalfFirmMinValue() {
        return 0L;
    }

    public static long onbehalfFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long onbehalfFirm() {
        return (long)this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int credentialsId() {
        return 35512;
    }

    public static int credentialsSinceVersion() {
        return 0;
    }

    public static String credentialsCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String credentialsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int credentialsHeaderLength() {
        return 1;
    }

    public int credentialsLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipCredentials() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getCredentials(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getCredentials(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapCredentials(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String credentials() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int clientIPId() {
        return 35513;
    }

    public static int clientIPSinceVersion() {
        return 0;
    }

    public static String clientIPCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String clientIPMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int clientIPHeaderLength() {
        return 1;
    }

    public int clientIPLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipClientIP() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getClientIP(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getClientIP(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapClientIP(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String clientIP() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getClientIP(Appendable appendable) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, (int)dataLength, appendable);
        return dataLength;
    }

    public static int clientAppNameId() {
        return 35514;
    }

    public static int clientAppNameSinceVersion() {
        return 0;
    }

    public static String clientAppNameCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String clientAppNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int clientAppNameHeaderLength() {
        return 1;
    }

    public int clientAppNameLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipClientAppName() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getClientAppName(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getClientAppName(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapClientAppName(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String clientAppName() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getClientAppName(Appendable appendable) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, (int)dataLength, appendable);
        return dataLength;
    }

    public static int clientAppVersionId() {
        return 35515;
    }

    public static int clientAppVersionSinceVersion() {
        return 0;
    }

    public static String clientAppVersionCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String clientAppVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int clientAppVersionHeaderLength() {
        return 1;
    }

    public int clientAppVersionLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipClientAppVersion() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getClientAppVersion(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getClientAppVersion(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapClientAppVersion(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String clientAppVersion() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getClientAppVersion(Appendable appendable) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, (int)dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        NegotiateDecoder decoder = new NegotiateDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[Negotiate](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 28) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(28);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("sessionID=");
        builder.append(this.sessionID());
        builder.append('|');
        builder.append("sessionVerID=");
        builder.append(this.sessionVerID());
        builder.append('|');
        builder.append("timestamp=");
        UTCTimestampNanosDecoder timestamp = this.timestamp();
        if (timestamp != null) {
            timestamp.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("clientFlow=");
        builder.append((Object)this.clientFlow());
        builder.append('|');
        builder.append("enteringFirm=");
        builder.append(this.enteringFirm());
        builder.append('|');
        builder.append("onbehalfFirm=");
        builder.append(this.onbehalfFirm());
        builder.append('|');
        builder.append("credentials=");
        builder.append('\'').append(this.credentials()).append('\'');
        builder.append('|');
        builder.append("clientIP=");
        builder.append('\'');
        this.getClientIP(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("clientAppName=");
        builder.append('\'');
        this.getClientAppName(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("clientAppVersion=");
        builder.append('\'');
        this.getClientAppVersion(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public NegotiateDecoder sbeSkip() {
        this.sbeRewind();
        this.skipCredentials();
        this.skipClientIP();
        this.skipClientAppName();
        this.skipClientAppVersion();
        return this;
    }
}

