/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.RetransmitRejectCode;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class RetransmitRejectDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 13;
    public static final int TEMPLATE_ID = 14;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RetransmitRejectDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final UTCTimestampNanosDecoder requestTimestamp = new UTCTimestampNanosDecoder();

    public int sbeBlockLength() {
        return 13;
    }

    public int sbeTemplateId() {
        return 14;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RetransmitRejectDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RetransmitRejectDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (14 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RetransmitRejectDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.RetransmitReject.value();
    }

    public MessageType messageType() {
        return MessageType.RetransmitReject;
    }

    public static int sessionIDId() {
        return 35518;
    }

    public static int sessionIDSinceVersion() {
        return 0;
    }

    public static int sessionIDEncodingOffset() {
        return 0;
    }

    public static int sessionIDEncodingLength() {
        return 4;
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIDNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long sessionIDMinValue() {
        return 0L;
    }

    public static long sessionIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long sessionID() {
        return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int requestTimestampId() {
        return 35521;
    }

    public static int requestTimestampSinceVersion() {
        return 0;
    }

    public static int requestTimestampEncodingOffset() {
        return 4;
    }

    public static int requestTimestampEncodingLength() {
        return 8;
    }

    public static String requestTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosDecoder requestTimestamp() {
        this.requestTimestamp.wrap(this.buffer, this.offset + 4);
        return this.requestTimestamp;
    }

    public static int retransmitRejectCodeId() {
        return 35534;
    }

    public static int retransmitRejectCodeSinceVersion() {
        return 0;
    }

    public static int retransmitRejectCodeEncodingOffset() {
        return 12;
    }

    public static int retransmitRejectCodeEncodingLength() {
        return 1;
    }

    public static String retransmitRejectCodeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short retransmitRejectCodeRaw() {
        return (short)(this.buffer.getByte(this.offset + 12) & 0xFF);
    }

    public RetransmitRejectCode retransmitRejectCode() {
        return RetransmitRejectCode.get((short)(this.buffer.getByte(this.offset + 12) & 0xFF));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RetransmitRejectDecoder decoder = new RetransmitRejectDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RetransmitReject](sbeTemplateId=");
        builder.append(14);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 13) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(13);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("sessionID=");
        builder.append(this.sessionID());
        builder.append('|');
        builder.append("requestTimestamp=");
        UTCTimestampNanosDecoder requestTimestamp = this.requestTimestamp();
        if (requestTimestamp != null) {
            requestTimestamp.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("retransmitRejectCode=");
        builder.append((Object)this.retransmitRejectCode());
        this.limit(originalLimit);
        return builder;
    }

    public RetransmitRejectDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

