/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.AllocNoOrdersType;
import b3.entrypoint.fixp.sbe.AllocTransType;
import b3.entrypoint.fixp.sbe.AllocType;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.Side;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class AllocationInstructionDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 45;
    public static final int TEMPLATE_ID = 601;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AllocationInstructionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final NoExecsDecoder noExecs = new NoExecsDecoder(this);
    private final NoAllocsDecoder noAllocs = new NoAllocsDecoder(this);

    public int sbeBlockLength() {
        return 45;
    }

    public int sbeTemplateId() {
        return 601;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public AllocationInstructionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public AllocationInstructionDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (601 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public AllocationInstructionDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.AllocationInstruction.value();
    }

    public MessageType messageType() {
        return MessageType.AllocationInstruction;
    }

    public static int allocIDId() {
        return 70;
    }

    public static int allocIDSinceVersion() {
        return 0;
    }

    public static int allocIDEncodingOffset() {
        return 0;
    }

    public static int allocIDEncodingLength() {
        return 8;
    }

    public static String allocIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long allocIDNullValue() {
        return -1L;
    }

    public static long allocIDMinValue() {
        return 0L;
    }

    public static long allocIDMaxValue() {
        return -2L;
    }

    public long allocID() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 8;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public long securityID() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 16;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 16;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int quantityId() {
        return 53;
    }

    public static int quantitySinceVersion() {
        return 0;
    }

    public static int quantityEncodingOffset() {
        return 16;
    }

    public static int quantityEncodingLength() {
        return 8;
    }

    public static String quantityMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long quantityNullValue() {
        return -1L;
    }

    public static long quantityMinValue() {
        return 0L;
    }

    public static long quantityMaxValue() {
        return -2L;
    }

    public long quantity() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 24;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public byte senderLocation(int index) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 24 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String senderLocationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getSenderLocation(byte[] dst, int dstOffset) {
        int length = 10;
        if (dstOffset < 0 || dstOffset > dst.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 24, dst, dstOffset, 10);
        return 10;
    }

    public String senderLocation() {
        int end;
        byte[] dst = new byte[10];
        this.buffer.getBytes(this.offset + 24, dst, 0, 10);
        for (end = 0; end < 10 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getSenderLocation(Appendable value) {
        for (int i = 0; i < 10; ++i) {
            int c = this.buffer.getByte(this.offset + 24 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 10;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 34;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public byte enteringTrader(int index) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 34 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getEnteringTrader(byte[] dst, int dstOffset) {
        int length = 5;
        if (dstOffset < 0 || dstOffset > dst.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 34, dst, dstOffset, 5);
        return 5;
    }

    public String enteringTrader() {
        int end;
        byte[] dst = new byte[5];
        this.buffer.getBytes(this.offset + 34, dst, 0, 5);
        for (end = 0; end < 5 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getEnteringTrader(Appendable value) {
        for (int i = 0; i < 5; ++i) {
            int c = this.buffer.getByte(this.offset + 34 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 5;
    }

    public static int tradeDateId() {
        return 75;
    }

    public static int tradeDateSinceVersion() {
        return 0;
    }

    public static int tradeDateEncodingOffset() {
        return 39;
    }

    public static int tradeDateEncodingLength() {
        return 2;
    }

    public static String tradeDateMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int tradeDateNullValue() {
        return 0;
    }

    public static int tradeDateMinValue() {
        return 0;
    }

    public static int tradeDateMaxValue() {
        return 65534;
    }

    public int tradeDate() {
        return this.buffer.getShort(this.offset + 39, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int allocTransTypeId() {
        return 71;
    }

    public static int allocTransTypeSinceVersion() {
        return 0;
    }

    public static int allocTransTypeEncodingOffset() {
        return 41;
    }

    public static int allocTransTypeEncodingLength() {
        return 1;
    }

    public static String allocTransTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte allocTransTypeRaw() {
        return this.buffer.getByte(this.offset + 41);
    }

    public AllocTransType allocTransType() {
        return AllocTransType.get(this.buffer.getByte(this.offset + 41));
    }

    public static int allocTypeId() {
        return 626;
    }

    public static int allocTypeSinceVersion() {
        return 0;
    }

    public static int allocTypeEncodingOffset() {
        return 42;
    }

    public static int allocTypeEncodingLength() {
        return 1;
    }

    public static String allocTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte allocTypeRaw() {
        return this.buffer.getByte(this.offset + 42);
    }

    public AllocType allocType() {
        return AllocType.get(this.buffer.getByte(this.offset + 42));
    }

    public static int allocNoOrdersTypeId() {
        return 857;
    }

    public static int allocNoOrdersTypeSinceVersion() {
        return 0;
    }

    public static int allocNoOrdersTypeEncodingOffset() {
        return 43;
    }

    public static int allocNoOrdersTypeEncodingLength() {
        return 1;
    }

    public static String allocNoOrdersTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte allocNoOrdersTypeRaw() {
        return this.buffer.getByte(this.offset + 43);
    }

    public AllocNoOrdersType allocNoOrdersType() {
        return AllocNoOrdersType.get(this.buffer.getByte(this.offset + 43));
    }

    public static int sideId() {
        return 54;
    }

    public static int sideSinceVersion() {
        return 0;
    }

    public static int sideEncodingOffset() {
        return 44;
    }

    public static int sideEncodingLength() {
        return 1;
    }

    public static String sideMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte sideRaw() {
        return this.buffer.getByte(this.offset + 44);
    }

    public Side side() {
        return Side.get(this.buffer.getByte(this.offset + 44));
    }

    public static long noExecsDecoderId() {
        return 124L;
    }

    public static int noExecsDecoderSinceVersion() {
        return 0;
    }

    public NoExecsDecoder noExecs() {
        this.noExecs.wrap(this.buffer);
        return this.noExecs;
    }

    public static long noAllocsDecoderId() {
        return 78L;
    }

    public static int noAllocsDecoderSinceVersion() {
        return 0;
    }

    public NoAllocsDecoder noAllocs() {
        this.noAllocs.wrap(this.buffer);
        return this.noAllocs;
    }

    public static int deskIDId() {
        return 35510;
    }

    public static int deskIDSinceVersion() {
        return 0;
    }

    public static String deskIDCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String deskIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int deskIDHeaderLength() {
        return 1;
    }

    public int deskIDLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipDeskID() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getDeskID(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getDeskID(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapDeskID(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String deskID() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getDeskID(Appendable appendable) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, (int)dataLength, appendable);
        return dataLength;
    }

    public static int memoId() {
        return 5149;
    }

    public static int memoSinceVersion() {
        return 0;
    }

    public static String memoCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String memoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int memoHeaderLength() {
        return 1;
    }

    public int memoLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipMemo() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMemo(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMemo(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMemo(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String memo() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        AllocationInstructionDecoder decoder = new AllocationInstructionDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[AllocationInstruction](sbeTemplateId=");
        builder.append(601);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 45) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(45);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("allocID=");
        builder.append(this.allocID());
        builder.append('|');
        builder.append("securityID=");
        builder.append(this.securityID());
        builder.append('|');
        builder.append("quantity=");
        builder.append(this.quantity());
        builder.append('|');
        builder.append("senderLocation=");
        for (i = 0; i < AllocationInstructionDecoder.senderLocationLength() && this.senderLocation(i) > 0; ++i) {
            builder.append((char)this.senderLocation(i));
        }
        builder.append('|');
        builder.append("enteringTrader=");
        for (i = 0; i < AllocationInstructionDecoder.enteringTraderLength() && this.enteringTrader(i) > 0; ++i) {
            builder.append((char)this.enteringTrader(i));
        }
        builder.append('|');
        builder.append("tradeDate=");
        builder.append(this.tradeDate());
        builder.append('|');
        builder.append("allocTransType=");
        builder.append((Object)this.allocTransType());
        builder.append('|');
        builder.append("allocType=");
        builder.append((Object)this.allocType());
        builder.append('|');
        builder.append("allocNoOrdersType=");
        builder.append((Object)this.allocNoOrdersType());
        builder.append('|');
        builder.append("side=");
        builder.append((Object)this.side());
        builder.append('|');
        builder.append("noExecs=[");
        int noExecsOriginalOffset = this.noExecs.offset;
        int noExecsOriginalIndex = this.noExecs.index;
        NoExecsDecoder noExecs = this.noExecs();
        if (noExecs.count() > 0) {
            while (noExecs.hasNext()) {
                noExecs.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        noExecs.offset = noExecsOriginalOffset;
        noExecs.index = noExecsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("noAllocs=[");
        int noAllocsOriginalOffset = this.noAllocs.offset;
        int noAllocsOriginalIndex = this.noAllocs.index;
        NoAllocsDecoder noAllocs = this.noAllocs();
        if (noAllocs.count() > 0) {
            while (noAllocs.hasNext()) {
                noAllocs.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        noAllocs.offset = noAllocsOriginalOffset;
        noAllocs.index = noAllocsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("deskID=");
        builder.append('\'');
        this.getDeskID(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("memo=");
        builder.append('\'').append(this.memo()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public AllocationInstructionDecoder sbeSkip() {
        NoAllocsDecoder noAllocs;
        this.sbeRewind();
        NoExecsDecoder noExecs = this.noExecs();
        if (noExecs.count() > 0) {
            while (noExecs.hasNext()) {
                noExecs.next();
                noExecs.sbeSkip();
            }
        }
        if ((noAllocs = this.noAllocs()).count() > 0) {
            while (noAllocs.hasNext()) {
                noAllocs.next();
                noAllocs.sbeSkip();
            }
        }
        this.skipDeskID();
        this.skipMemo();
        return this;
    }

    public static final class NoAllocsDecoder
    implements Iterable<NoAllocsDecoder>,
    Iterator<NoAllocsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final AllocationInstructionDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        NoAllocsDecoder(AllocationInstructionDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public NoAllocsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 20;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<NoAllocsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int individualAllocIDId() {
            return 467;
        }

        public static int individualAllocIDSinceVersion() {
            return 0;
        }

        public static int individualAllocIDEncodingOffset() {
            return 0;
        }

        public static int individualAllocIDEncodingLength() {
            return 8;
        }

        public static String individualAllocIDMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long individualAllocIDNullValue() {
            return -1L;
        }

        public static long individualAllocIDMinValue() {
            return 0L;
        }

        public static long individualAllocIDMaxValue() {
            return -2L;
        }

        public long individualAllocID() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int allocAccountId() {
            return 79;
        }

        public static int allocAccountSinceVersion() {
            return 0;
        }

        public static int allocAccountEncodingOffset() {
            return 8;
        }

        public static int allocAccountEncodingLength() {
            return 4;
        }

        public static String allocAccountMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "optional";
            }
            return "";
        }

        public static long allocAccountNullValue() {
            return 0L;
        }

        public static long allocAccountMinValue() {
            return 0L;
        }

        public static long allocAccountMaxValue() {
            return 0xFFFFFFFEL;
        }

        public long allocAccount() {
            return (long)this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
        }

        public static int allocQtyId() {
            return 80;
        }

        public static int allocQtySinceVersion() {
            return 0;
        }

        public static int allocQtyEncodingOffset() {
            return 12;
        }

        public static int allocQtyEncodingLength() {
            return 8;
        }

        public static String allocQtyMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long allocQtyNullValue() {
            return -1L;
        }

        public static long allocQtyMinValue() {
            return 0L;
        }

        public static long allocQtyMaxValue() {
            return -2L;
        }

        public long allocQty() {
            return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("individualAllocID=");
            builder.append(this.individualAllocID());
            builder.append('|');
            builder.append("allocAccount=");
            builder.append(this.allocAccount());
            builder.append('|');
            builder.append("allocQty=");
            builder.append(this.allocQty());
            builder.append(')');
            return builder;
        }

        public NoAllocsDecoder sbeSkip() {
            return this;
        }
    }

    public static final class NoExecsDecoder
    implements Iterable<NoExecsDecoder>,
    Iterator<NoExecsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final AllocationInstructionDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        NoExecsDecoder(AllocationInstructionDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public NoExecsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 4;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<NoExecsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int tradeIDId() {
            return 1003;
        }

        public static int tradeIDSinceVersion() {
            return 0;
        }

        public static int tradeIDEncodingOffset() {
            return 0;
        }

        public static int tradeIDEncodingLength() {
            return 4;
        }

        public static String tradeIDMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "optional";
            }
            return "";
        }

        public static long tradeIDNullValue() {
            return 0L;
        }

        public static long tradeIDMinValue() {
            return 0L;
        }

        public static long tradeIDMaxValue() {
            return 0xFFFFFFFEL;
        }

        public long tradeID() {
            return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("tradeID=");
            builder.append(this.tradeID());
            builder.append(')');
            return builder;
        }

        public NoExecsDecoder sbeSkip() {
            return this;
        }
    }
}

