/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.Boolean;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosDecoder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class QuoteRequestRejectDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 52;
    public static final int TEMPLATE_ID = 405;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final QuoteRequestRejectDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final UTCTimestampNanosDecoder transactTime = new UTCTimestampNanosDecoder();

    public int sbeBlockLength() {
        return 52;
    }

    public int sbeTemplateId() {
        return 405;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public QuoteRequestRejectDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public QuoteRequestRejectDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (405 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public QuoteRequestRejectDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.QuoteRequestReject.value();
    }

    public MessageType messageType() {
        return MessageType.QuoteRequestReject;
    }

    public static int quoteReqIDId() {
        return 131;
    }

    public static int quoteReqIDSinceVersion() {
        return 0;
    }

    public static int quoteReqIDEncodingOffset() {
        return 0;
    }

    public static int quoteReqIDEncodingLength() {
        return 8;
    }

    public static String quoteReqIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long quoteReqIDNullValue() {
        return -1L;
    }

    public static long quoteReqIDMinValue() {
        return 0L;
    }

    public static long quoteReqIDMaxValue() {
        return -2L;
    }

    public long quoteReqID() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int quoteIDId() {
        return 117;
    }

    public static int quoteIDSinceVersion() {
        return 0;
    }

    public static int quoteIDEncodingOffset() {
        return 8;
    }

    public static int quoteIDEncodingLength() {
        return 8;
    }

    public static String quoteIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long quoteIDNullValue() {
        return 0L;
    }

    public static long quoteIDMinValue() {
        return 0L;
    }

    public static long quoteIDMaxValue() {
        return -2L;
    }

    public long quoteID() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 16;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public long securityID() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 24;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 24;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int transactTimeId() {
        return 60;
    }

    public static int transactTimeSinceVersion() {
        return 0;
    }

    public static int transactTimeEncodingOffset() {
        return 24;
    }

    public static int transactTimeEncodingLength() {
        return 8;
    }

    public static String transactTimeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosDecoder transactTime() {
        this.transactTime.wrap(this.buffer, this.offset + 24);
        return this.transactTime;
    }

    public static int quoteRequestRejectReasonId() {
        return 658;
    }

    public static int quoteRequestRejectReasonSinceVersion() {
        return 0;
    }

    public static int quoteRequestRejectReasonEncodingOffset() {
        return 32;
    }

    public static int quoteRequestRejectReasonEncodingLength() {
        return 4;
    }

    public static String quoteRequestRejectReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long quoteRequestRejectReasonNullValue() {
        return 0L;
    }

    public static long quoteRequestRejectReasonMinValue() {
        return 0L;
    }

    public static long quoteRequestRejectReasonMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long quoteRequestRejectReason() {
        return (long)this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 36;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public byte senderLocation(int index) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 36 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String senderLocationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getSenderLocation(byte[] dst, int dstOffset) {
        int length = 10;
        if (dstOffset < 0 || dstOffset > dst.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 36, dst, dstOffset, 10);
        return 10;
    }

    public String senderLocation() {
        int end;
        byte[] dst = new byte[10];
        this.buffer.getBytes(this.offset + 36, dst, 0, 10);
        for (end = 0; end < 10 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getSenderLocation(Appendable value) {
        for (int i = 0; i < 10; ++i) {
            int c = this.buffer.getByte(this.offset + 36 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 10;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 46;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public byte enteringTrader(int index) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 46 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getEnteringTrader(byte[] dst, int dstOffset) {
        int length = 5;
        if (dstOffset < 0 || dstOffset > dst.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 46, dst, dstOffset, 5);
        return 5;
    }

    public String enteringTrader() {
        int end;
        byte[] dst = new byte[5];
        this.buffer.getBytes(this.offset + 46, dst, 0, 5);
        for (end = 0; end < 5 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getEnteringTrader(Appendable value) {
        for (int i = 0; i < 5; ++i) {
            int c = this.buffer.getByte(this.offset + 46 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 5;
    }

    public static int privateQuoteId() {
        return 1171;
    }

    public static int privateQuoteSinceVersion() {
        return 0;
    }

    public static int privateQuoteEncodingOffset() {
        return 51;
    }

    public static int privateQuoteEncodingLength() {
        return 1;
    }

    public static String privateQuoteMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public short privateQuoteRaw() {
        return (short)(this.buffer.getByte(this.offset + 51) & 0xFF);
    }

    public Boolean privateQuote() {
        return Boolean.get((short)(this.buffer.getByte(this.offset + 51) & 0xFF));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        QuoteRequestRejectDecoder decoder = new QuoteRequestRejectDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[QuoteRequestReject](sbeTemplateId=");
        builder.append(405);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 52) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(52);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("quoteReqID=");
        builder.append(this.quoteReqID());
        builder.append('|');
        builder.append("quoteID=");
        builder.append(this.quoteID());
        builder.append('|');
        builder.append("securityID=");
        builder.append(this.securityID());
        builder.append('|');
        builder.append("transactTime=");
        UTCTimestampNanosDecoder transactTime = this.transactTime();
        if (transactTime != null) {
            transactTime.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("quoteRequestRejectReason=");
        builder.append(this.quoteRequestRejectReason());
        builder.append('|');
        builder.append("senderLocation=");
        for (i = 0; i < QuoteRequestRejectDecoder.senderLocationLength() && this.senderLocation(i) > 0; ++i) {
            builder.append((char)this.senderLocation(i));
        }
        builder.append('|');
        builder.append("enteringTrader=");
        for (i = 0; i < QuoteRequestRejectDecoder.enteringTraderLength() && this.enteringTrader(i) > 0; ++i) {
            builder.append((char)this.enteringTrader(i));
        }
        builder.append('|');
        builder.append("privateQuote=");
        builder.append((Object)this.privateQuote());
        this.limit(originalLimit);
        return builder;
    }

    public QuoteRequestRejectDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

