/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.CompositeDecoderFlyweight;

public final class PriceDecoder
implements CompositeDecoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final int ENCODED_LENGTH = 8;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public PriceDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 8;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public static int mantissaEncodingOffset() {
        return 0;
    }

    public static int mantissaEncodingLength() {
        return 8;
    }

    public static int mantissaSinceVersion() {
        return 0;
    }

    public static long mantissaNullValue() {
        return Long.MIN_VALUE;
    }

    public static long mantissaMinValue() {
        return -9223372036854775807L;
    }

    public static long mantissaMaxValue() {
        return Long.MAX_VALUE;
    }

    public long mantissa() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int exponentEncodingOffset() {
        return 8;
    }

    public static int exponentEncodingLength() {
        return 0;
    }

    public static int exponentSinceVersion() {
        return 0;
    }

    public static byte exponentNullValue() {
        return -128;
    }

    public static byte exponentMinValue() {
        return -127;
    }

    public static byte exponentMaxValue() {
        return 127;
    }

    public byte exponent() {
        return -3;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("mantissa=");
        builder.append(this.mantissa());
        builder.append('|');
        builder.append(')');
        return builder;
    }
}

