package uk.co.markormesher.android_fab

import android.content.Context
import android.graphics.Color
import android.support.annotation.ColorInt

abstract class SpeedDialMenuAdapter {

	/**
	 * Gets the number of items represented by this adapter.
	 * Note: returning zero has the same effect as return `false` from `isEnabled()`.
	 * @return the number of items represented by this adapter
	 */
	abstract fun getCount(): Int

	/**
	 * Gets the menu item to display at the specified position in the range 0 to `getCount() - 1`.
	 * See `SpeedDialMenuItem` for more details.
	 * Note: positions start at zero closest to the FAB and increase for items further away.
	 * @return the menu item to display at the specified position
	 */
	abstract fun getMenuItem(context: Context, position: Int): SpeedDialMenuItem

	/**
	 * Handler for click events on menu items.
	 * The position passed corresponds to positions passed to `getMenuItem()`.
	 * @return `true` to close the menu after the click; `false` to leave it open
	 */
	open fun onMenuItemClick(position: Int): Boolean = true

	/**
	 * Gets the colour of the background tile behind the menu item.
	 * Positions correspond to positions passed to `getMenuItem()`.
	 * Note: this method should return an aRGB colour integer, *not* a colour resource ID.
	 * @return the colour of the card behind the icon at the specified position
	 */
	@ColorInt open fun getBackgroundColour(position: Int): Int = Color.argb(255, 192, 192, 192)

	/**
	 * Gets the number of degrees to rotate the FAB's icon when the speed-dial menu opens.
	 * This is useful for the popular "plus icon"/"close icon" transition.
	 * @return the number of degrees to rotate the FAB's icon when the speed-dial menu opens
	 */
	open fun fabRotationDegrees() = 0F

	/**
	 * Determines whether or not the speed-dial menu is enabled.
	 * @return `true` if the menu is enabled; `false` if it is not
	 */
	open fun isEnabled() = true

}
