/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.flowtextview.helpers;

import java.util.ArrayList;
import uk.co.deanwild.flowtextview.models.Area;
import uk.co.deanwild.flowtextview.models.Line;
import uk.co.deanwild.flowtextview.models.Obstacle;

public class CollisionHelper {
    private static final ArrayList<Area> mAreas = new ArrayList();

    public static Line calculateLineSpaceForGivenYOffset(float lineYbottom, int lineHeight, float viewWidth, ArrayList<Obstacle> obstacles) {
        Line line = new Line();
        line.leftBound = 0.0f;
        line.rightBound = viewWidth;
        float lineYtop = lineYbottom - (float)lineHeight;
        mAreas.clear();
        for (Obstacle obstacle : obstacles) {
            if ((float)obstacle.topLefty > lineYbottom || (float)obstacle.bottomRighty < lineYtop) continue;
            Area leftArea = new Area();
            leftArea.x1 = 0.0f;
            for (Obstacle innerObstacle : obstacles) {
                if ((float)innerObstacle.topLefty > lineYbottom || (float)innerObstacle.bottomRighty < lineYtop || innerObstacle.topLeftx >= obstacle.topLeftx) continue;
                leftArea.x1 = innerObstacle.bottomRightx;
            }
            leftArea.x2 = obstacle.topLeftx;
            leftArea.width = leftArea.x2 - leftArea.x1;
            Area rightArea = new Area();
            rightArea.x1 = obstacle.bottomRightx;
            rightArea.x2 = viewWidth;
            for (Obstacle innerObstacle : obstacles) {
                if ((float)innerObstacle.topLefty > lineYbottom || (float)innerObstacle.bottomRighty < lineYtop || innerObstacle.bottomRightx <= obstacle.bottomRightx) continue;
                rightArea.x2 = innerObstacle.topLeftx;
            }
            rightArea.width = rightArea.x2 - rightArea.x1;
            mAreas.add(leftArea);
            mAreas.add(rightArea);
        }
        Area mLargestArea = null;
        if (mAreas.size() > 0) {
            for (Area area : mAreas) {
                if (mLargestArea == null) {
                    mLargestArea = area;
                    continue;
                }
                if (!(area.width > mLargestArea.width)) continue;
                mLargestArea = area;
            }
            line.leftBound = mLargestArea.x1;
            line.rightBound = mLargestArea.x2;
        }
        return line;
    }
}

