/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.flowtextview;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import uk.co.deanwild.flowtextview.helpers.ClickHandler;
import uk.co.deanwild.flowtextview.helpers.CollisionHelper;
import uk.co.deanwild.flowtextview.helpers.PaintHelper;
import uk.co.deanwild.flowtextview.helpers.SpanParser;
import uk.co.deanwild.flowtextview.listeners.OnLinkClickListener;
import uk.co.deanwild.flowtextview.models.HtmlLink;
import uk.co.deanwild.flowtextview.models.HtmlObject;
import uk.co.deanwild.flowtextview.models.Line;
import uk.co.deanwild.flowtextview.models.Obstacle;

public class FlowTextView
extends RelativeLayout {
    private final PaintHelper mPaintHelper = new PaintHelper();
    private final SpanParser mSpanParser = new SpanParser(this, this.mPaintHelper);
    private final ClickHandler mClickHandler = new ClickHandler(this.mSpanParser);
    private int mColor = -16777216;
    private int pageHeight = 0;
    private TextPaint mTextPaint;
    private TextPaint mLinkPaint;
    private float mTextsize = 20.0f;
    private Typeface typeFace;
    private int mDesiredHeight = 100;
    private boolean needsMeasure = true;
    private final ArrayList<Obstacle> obstacles = new ArrayList();
    private CharSequence mText = "";
    private boolean mIsHtml = false;

    public FlowTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public FlowTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FlowTextView(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = this.getResources().getDisplayMetrics().density;
        this.mTextPaint.setTextSize(this.mTextsize);
        this.mTextPaint.setColor(-16777216);
        this.mLinkPaint = new TextPaint(1);
        this.mLinkPaint.density = this.getResources().getDisplayMetrics().density;
        this.mLinkPaint.setTextSize(this.mTextsize);
        this.mLinkPaint.setColor(-16776961);
        this.mLinkPaint.setUnderlineText(true);
        this.setBackgroundColor(0);
        this.setOnTouchListener(this.mClickHandler);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float mViewWidth = this.getWidth();
        this.obstacles.clear();
        int lowestYCoord = this.findBoxesAndReturnLowestObstacleYCoord();
        String[] blocks = this.mText.toString().split("\n");
        int charOffsetStart = 0;
        int charOffsetEnd = 0;
        int lineIndex = 0;
        float yOffset = 0.0f;
        int lineHeight = this.getLineHeight();
        ArrayList<HtmlObject> lineObjects = new ArrayList<HtmlObject>();
        this.mSpanParser.reset();
        for (int block_no = 0; block_no <= blocks.length - 1; ++block_no) {
            String thisBlock = blocks[block_no];
            if (thisBlock.length() <= 0) {
                ++lineIndex;
                charOffsetStart = charOffsetEnd += 2;
                continue;
            }
            while (thisBlock.length() > 0) {
                String thisLineStr;
                int chunkSize;
                float actualWidth;
                yOffset = ++lineIndex * lineHeight;
                Line thisLine = CollisionHelper.calculateLineSpaceForGivenYOffset(yOffset, lineHeight, mViewWidth, this.obstacles);
                float xOffset = thisLine.leftBound;
                float maxWidth = thisLine.rightBound - thisLine.leftBound;
                do {
                    Object[] spans;
                    chunkSize = this.getChunk(thisBlock, maxWidth);
                    int thisCharOffset = charOffsetEnd + chunkSize;
                    thisLineStr = chunkSize > 1 ? thisBlock.substring(0, chunkSize) : "";
                    lineObjects.clear();
                    actualWidth = this.mIsHtml ? ((spans = ((Spanned)this.mText).getSpans(charOffsetStart, thisCharOffset, Object.class)).length > 0 ? this.mSpanParser.parseSpans(lineObjects, spans, charOffsetStart, thisCharOffset, xOffset) : maxWidth) : maxWidth;
                    if (!(actualWidth > maxWidth)) continue;
                    maxWidth -= 5.0f;
                } while (actualWidth > maxWidth);
                charOffsetEnd += chunkSize;
                if (lineObjects.size() <= 0) {
                    HtmlObject htmlLine = new HtmlObject(thisLineStr, 0, 0, xOffset, this.mTextPaint);
                    lineObjects.add(htmlLine);
                }
                for (HtmlObject thisHtmlObject : lineObjects) {
                    if (thisHtmlObject instanceof HtmlLink) {
                        HtmlLink thisLink = (HtmlLink)thisHtmlObject;
                        float thisLinkWidth = thisLink.paint.measureText(thisHtmlObject.content);
                        this.mSpanParser.addLink(thisLink, yOffset, thisLinkWidth, lineHeight);
                    }
                    this.paintObject(canvas, thisHtmlObject.content, thisHtmlObject.xOffset, yOffset, (Paint)thisHtmlObject.paint);
                    if (!thisHtmlObject.recycle) continue;
                    this.mPaintHelper.recyclePaint(thisHtmlObject.paint);
                }
                if (chunkSize >= 1) {
                    thisBlock = thisBlock.substring(chunkSize, thisBlock.length());
                }
                charOffsetStart = charOffsetEnd;
            }
        }
        yOffset += (float)(lineHeight / 2);
        View child = this.getChildAt(this.getChildCount() - 1);
        if (child.getTag() != null && child.getTag().toString().equalsIgnoreCase("hideable")) {
            if (yOffset > (float)this.pageHeight) {
                if (yOffset < (float)(this.obstacles.get((int)(this.obstacles.size() - 1)).topLefty - this.getLineHeight())) {
                    child.setVisibility(8);
                } else {
                    child.setVisibility(0);
                }
            } else {
                child.setVisibility(8);
            }
        }
        this.mDesiredHeight = Math.max(lowestYCoord, (int)yOffset);
        if (this.needsMeasure) {
            this.needsMeasure = false;
            this.requestLayout();
        }
    }

    private int findBoxesAndReturnLowestObstacleYCoord() {
        int lowestYCoord = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            Obstacle obstacle = new Obstacle();
            obstacle.topLeftx = child.getLeft();
            obstacle.topLefty = child.getTop();
            obstacle.bottomRightx = obstacle.topLeftx + child.getWidth();
            obstacle.bottomRighty = obstacle.topLefty + child.getHeight();
            this.obstacles.add(obstacle);
            if (obstacle.bottomRighty <= lowestYCoord) continue;
            lowestYCoord = obstacle.bottomRighty;
        }
        return lowestYCoord;
    }

    private int getChunk(String text, float maxWidth) {
        int length = this.mTextPaint.breakText(text, true, maxWidth, null);
        if (length <= 0) {
            return length;
        }
        if (length >= text.length()) {
            return length;
        }
        if (text.charAt(length - 1) == ' ') {
            return length;
        }
        if (text.length() > length && text.charAt(length) == ' ') {
            return length + 1;
        }
        int tempLength = length - 1;
        while (text.charAt(tempLength) != ' ') {
            if (--tempLength > 0) continue;
            return length;
        }
        return tempLength + 1;
    }

    private void paintObject(Canvas canvas, String thisLineStr, float xOffset, float yOffset, Paint paint) {
        canvas.drawText(thisLineStr, xOffset, yOffset, paint);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.invalidate();
    }

    public void invalidate() {
        this.needsMeasure = true;
        super.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : this.getWidth();
        int height = heightMode == 0x40000000 ? heightSize : this.mDesiredHeight;
        this.setMeasuredDimension(width, height + this.getLineHeight());
    }

    public float getTextsize() {
        return this.mTextsize;
    }

    public void setTextSize(float textSize) {
        this.mTextsize = textSize;
        this.mTextPaint.setTextSize(this.mTextsize);
        this.mLinkPaint.setTextSize(this.mTextsize);
        this.invalidate();
    }

    public Typeface getTypeFace() {
        return this.typeFace;
    }

    public void setTypeface(Typeface type) {
        this.typeFace = type;
        this.mTextPaint.setTypeface(this.typeFace);
        this.mLinkPaint.setTypeface(this.typeFace);
        this.invalidate();
    }

    public TextPaint getTextPaint() {
        return this.mTextPaint;
    }

    public void setTextPaint(TextPaint mTextPaint) {
        this.mTextPaint = mTextPaint;
        this.invalidate();
    }

    public TextPaint getLinkPaint() {
        return this.mLinkPaint;
    }

    public void setLinkPaint(TextPaint mLinkPaint) {
        this.mLinkPaint = mLinkPaint;
        this.invalidate();
    }

    public CharSequence getText() {
        return this.mText;
    }

    public void setText(CharSequence text) {
        this.mText = text;
        if (text instanceof Spannable) {
            this.mIsHtml = true;
            this.mSpanParser.setSpannable((Spannable)text);
        } else {
            this.mIsHtml = false;
        }
        this.invalidate();
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
        if (this.mTextPaint != null) {
            this.mTextPaint.setColor(this.mColor);
        }
        this.mPaintHelper.setColor(this.mColor);
        this.invalidate();
    }

    public OnLinkClickListener getOnLinkClickListener() {
        return this.mClickHandler.getOnLinkClickListener();
    }

    public void setOnLinkClickListener(OnLinkClickListener onLinkClickListener) {
        this.mClickHandler.setOnLinkClickListener(onLinkClickListener);
    }

    public int getLineHeight() {
        float mSpacingMult = 1.0f;
        float mSpacingAdd = 0.0f;
        return Math.round((float)this.mTextPaint.getFontMetricsInt(null) * mSpacingMult + mSpacingAdd);
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
        this.invalidate();
    }
}

