/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.Futures;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import uk.co.coen.capsulecrm.client.CTasks;
import uk.co.coen.capsulecrm.client.SimpleCapsuleEntity;
import uk.co.coen.capsulecrm.client.TaskStatus;
import uk.co.coen.capsulecrm.client.utils.ListenableFutureAdapter;
import uk.co.coen.capsulecrm.client.utils.ThrowOnHttpFailure;
import uk.co.coen.capsulecrm.client.utils.UnmarshalResponseBody;

public class CTask
extends SimpleCapsuleEntity {
    public String description;
    public String detail;
    public String category;
    public TaskStatus status;
    public DateTime dueDate;
    public DateTime dueDateTime;
    public DateTime completedOn;
    public String owner;
    public Long partyId;
    public String partyName;
    public Long caseId;
    public String caseName;
    public Long opportunityId;
    public String opportunityName;

    public CTask() {
    }

    public CTask(String string, DateTime dateTime) {
        this(string, null, dateTime, true);
    }

    public CTask(String string, DateTime dateTime, boolean bl) {
        this(string, null, dateTime, bl);
    }

    public CTask(String string, String string2, DateTime dateTime, boolean bl) {
        this.description = string;
        this.detail = string2;
        if (bl) {
            this.dueDateTime = dateTime;
        } else {
            this.dueDate = dateTime;
        }
    }

    @Override
    protected String readContextPath() {
        return "/task";
    }

    public static Future<CTasks> list() throws IOException {
        return CTask.list(null, null, null, 0, 0);
    }

    public static Future<CTasks> listByCategory(String string) throws IOException {
        return CTask.list(string, null, null, 0, 0);
    }

    public static Future<CTasks> listByUser(String string) throws IOException {
        return CTask.list(null, string, null, 0, 0);
    }

    public static Future<CTasks> list(int n, int n2) throws IOException {
        return CTask.list(null, null, null, n, n2);
    }

    public static Future<CTasks> list(TaskStatus taskStatus) throws IOException {
        return CTask.list(null, null, taskStatus, 0, 0);
    }

    public static Future<CTasks> list(TaskStatus taskStatus, int n, int n2) throws IOException {
        return CTask.list(null, null, taskStatus, n, n2);
    }

    public static Future<CTasks> list(String string, String string2, TaskStatus taskStatus, int n, int n2) throws IOException {
        AsyncHttpClient.BoundRequestBuilder boundRequestBuilder = asyncHttpClient.prepareGet(capsuleUrl + "/api/tasks");
        if (string != null) {
            boundRequestBuilder.addQueryParameter("category", string);
        }
        if (string2 != null) {
            boundRequestBuilder.addQueryParameter("user", string2);
        }
        if (taskStatus != null) {
            boundRequestBuilder.addQueryParameter("status", taskStatus.name());
        }
        if (n != 0) {
            boundRequestBuilder.addQueryParameter("start", "" + n);
        }
        if (n2 != 0) {
            boundRequestBuilder.addQueryParameter("limit", "" + n2);
        }
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)boundRequestBuilder.addHeader("Accept", "application/xml").setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public Future<Response> complete() throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(capsuleUrl + "/api/task/" + this.id + "/complete").addHeader("Accept", "application/xml").setRealm(realm)).setBody("").execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

            public Response onCompleted(Response response) throws Exception {
                if (response.getStatusCode() == 200) {
                    CTask.this.status = TaskStatus.COMPLETED;
                }
                return response;
            }
        });
    }

    public Future<Response> reopen() throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(capsuleUrl + "/api/task/" + this.id + "/reopen").addHeader("Accept", "application/xml").setRealm(realm)).setBody("").execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

            public Response onCompleted(Response response) throws Exception {
                if (response.getStatusCode() == 200) {
                    CTask.this.status = TaskStatus.OPEN;
                }
                return response;
            }
        });
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("description", (Object)this.description).add("detail", (Object)this.detail).add("category", (Object)this.category).add("status", (Object)this.status).add("dueDate", (Object)this.dueDate).add("dueDateTime", (Object)this.dueDateTime).add("completedOn", (Object)this.completedOn).add("owner", (Object)this.owner).add("partyId", (Object)this.partyId).add("partyName", (Object)this.partyName).add("caseId", (Object)this.caseId).add("caseName", (Object)this.caseName).add("opportunityId", (Object)this.opportunityId).add("opportunityName", (Object)this.opportunityName).toString();
    }
}

