/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import uk.co.coen.capsulecrm.client.CAddress;
import uk.co.coen.capsulecrm.client.CContact;
import uk.co.coen.capsulecrm.client.CEmail;
import uk.co.coen.capsulecrm.client.CParties;
import uk.co.coen.capsulecrm.client.CPhone;
import uk.co.coen.capsulecrm.client.CTask;
import uk.co.coen.capsulecrm.client.CTasks;
import uk.co.coen.capsulecrm.client.CWebsite;
import uk.co.coen.capsulecrm.client.CapsuleEntity;
import uk.co.coen.capsulecrm.client.TaskStatus;
import uk.co.coen.capsulecrm.client.WebService;
import uk.co.coen.capsulecrm.client.utils.ListenableFutureAdapter;
import uk.co.coen.capsulecrm.client.utils.ThrowOnHttpFailure;
import uk.co.coen.capsulecrm.client.utils.UnmarshalResponseBody;

public abstract class CParty
extends CapsuleEntity {
    public List<CContact> contacts;
    public String about;
    public String pictureURL;
    public DateTime lastContactedOn;

    public abstract String getName();

    public void addContact(CContact cContact) {
        if (this.contacts == null) {
            this.contacts = Lists.newArrayList();
        }
        this.contacts.add(cContact);
    }

    public CAddress firstAddress() {
        for (CContact cContact : this.contacts) {
            if (!(cContact instanceof CAddress)) continue;
            return (CAddress)cContact;
        }
        return null;
    }

    public CEmail firstEmail() {
        for (CContact cContact : this.contacts) {
            if (!(cContact instanceof CEmail)) continue;
            return (CEmail)cContact;
        }
        return null;
    }

    public CPhone firstPhone() {
        for (CContact cContact : this.contacts) {
            if (!(cContact instanceof CPhone)) continue;
            return (CPhone)cContact;
        }
        return null;
    }

    public CWebsite firstWebsite() {
        return this.firstWebsite(null);
    }

    public CWebsite firstWebsite(WebService webService) {
        for (CContact cContact : this.contacts) {
            if (!(cContact instanceof CWebsite)) continue;
            CWebsite cWebsite = (CWebsite)cContact;
            if (webService != null && webService != cWebsite.webService) continue;
            return (CWebsite)cContact;
        }
        return null;
    }

    @Override
    public String readContextPath() {
        return "/party";
    }

    public Future<CTasks> listTasks() throws IOException {
        return this.listTasks(null);
    }

    public Future<CTasks> listTasks(TaskStatus taskStatus) throws IOException {
        AsyncHttpClient.BoundRequestBuilder boundRequestBuilder = asyncHttpClient.prepareGet(capsuleUrl + "/api/tasks");
        if (taskStatus != null) {
            boundRequestBuilder.addQueryParameter("status", taskStatus.name());
        }
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)boundRequestBuilder.addHeader("Accept", "application/xml").setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure())), (Function)new UnmarshalResponseBody<CTasks>(xstream){

            @Override
            public CTasks apply(Response response) {
                CTasks cTasks = (CTasks)super.apply(response);
                cTasks.tasks = Lists.newArrayList((Iterable)Collections2.filter(cTasks.tasks, (Predicate)new Predicate<CTask>(){

                    public boolean apply(CTask cTask) {
                        return cTask.partyId != null && cTask.partyId.equals(CParty.this.id);
                    }
                }));
                cTasks.size = cTasks.tasks.size();
                return cTasks;
            }
        });
    }

    public static Future<CParties> search(String string) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/party").addQueryParameter("q", string).addHeader("Accept", "application/xml").setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<CParties> listAll() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/party").addHeader("Accept", "application/xml").setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<CParties> listModifiedSince(DateTime dateTime) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/party").addQueryParameter("lastmodified", dateTime.toString("yyyyMMdd'T'HHmmss")).addHeader("Accept", "application/xml").setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<CParties> listByEmailAddress(String string) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/party").addQueryParameter("email", string).addHeader("Accept", "application/xml").setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<CParties> listByTag(String string) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/party").addQueryParameter("tag", string).addHeader("Accept", "application/xml").setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<CParty> byId(Integer n) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/party/" + n).addHeader("Accept", "application/xml").setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public Future<Response> deleteContact(CContact cContact) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareDelete(capsuleUrl + "/api/party/" + this.id + "/contact/" + cContact.id).setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure());
    }
}

