/*
 * Decompiled with CFR 0.152.
 */
package uk.co.alt236.resourcemirror.reflectors.base;

import android.support.annotation.NonNull;
import android.util.Log;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.co.alt236.resourcemirror.ResourceType;

class ReflectionCore {
    private final String TAG = this.getClass().getSimpleName();
    private final String mPackageName;
    private final Map<String, Class<?>> mClassCache;

    public ReflectionCore(String appPackageName) {
        this.mPackageName = appPackageName;
        this.mClassCache = new HashMap();
    }

    private Class<?> getResourceClass(String suffix) {
        if (this.mClassCache.containsKey(suffix)) {
            return this.mClassCache.get(suffix);
        }
        try {
            Class<?>[] subClassTable;
            Class<?> rClassBase = Class.forName(this.mPackageName + ".R");
            for (Class<?> subClass : subClassTable = rClassBase.getDeclaredClasses()) {
                if (!subClass.getCanonicalName().endsWith(suffix)) continue;
                this.mClassCache.put(suffix, subClass);
                return subClass;
            }
        }
        catch (ClassNotFoundException e) {
            Log.e((String)this.TAG, (String)("getResourceClass() ClassNotFoundException: " + e.getMessage()), (Throwable)e);
        }
        Log.e((String)this.TAG, (String)("getResourceClass() Unable to find Sublass: " + suffix));
        return null;
    }

    @NonNull
    public List<String> getResourceList(ResourceType type) {
        ArrayList<String> list = new ArrayList<String>();
        Class<?> resourceClass = this.getResourceClass(ReflectionCore.getResourceLocation(type));
        if (resourceClass != null) {
            Field[] resourceArray;
            for (Field field : resourceArray = resourceClass.getFields()) {
                try {
                    if (!Integer.TYPE.equals(field.getType())) continue;
                    list.add(field.getName());
                }
                catch (IllegalArgumentException e) {
                    Log.e((String)this.TAG, (String)("getResourceList() Error: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        Collections.sort(list);
        return Collections.unmodifiableList(list);
    }

    @NonNull
    public List<String> getResourceTypes() {
        String baseClass = this.mPackageName + ".R";
        ArrayList<String> list = new ArrayList<String>();
        Log.d((String)this.TAG, (String)("getResourceClass() Getting for '" + baseClass + "' ============= "));
        try {
            Class<?>[] subClassTable;
            Class<?> rClassBase = Class.forName(baseClass);
            for (Class<?> subClass : subClassTable = rClassBase.getDeclaredClasses()) {
                Log.d((String)this.TAG, (String)("getResourceClass() Name: " + subClass.getName()));
                list.add(subClass.getSimpleName());
            }
        }
        catch (ClassNotFoundException e) {
            Log.e((String)this.TAG, (String)("getResourceClass() ClassNotFoundException: " + e.getMessage()), (Throwable)e);
        }
        return list;
    }

    public void logFields(ResourceType type) {
        String resourceLocation = ReflectionCore.getResourceLocation(type);
        Log.d((String)this.TAG, (String)("logFields() Getting Fields for '" + resourceLocation + "' ============= "));
        try {
            Field[] fields;
            for (Field field : fields = this.getResourceClass(resourceLocation).getFields()) {
                Log.d((String)this.TAG, (String)("logFields() Field: '" + field.getName() + "'"));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int reflectResource(ResourceType type, String fieldName, int defaultValue, boolean reportFailure) {
        int error;
        String resourceLocation = ReflectionCore.getResourceLocation(type);
        try {
            Field field = this.getResourceClass(resourceLocation).getField(fieldName);
            if (field.getType().equals(Integer.TYPE)) {
                return field.getInt(null);
            }
            Log.w((String)this.TAG, (String)String.format("reflectResource() Error getting resource Id for item '" + fieldName + "'. It is not of type int: Type = '%s'", field.getGenericType().toString()));
            return defaultValue;
        }
        catch (NoSuchFieldException e) {
            error = 1;
        }
        catch (IllegalAccessException e) {
            error = 2;
        }
        catch (NullPointerException e) {
            error = 3;
        }
        if (reportFailure) {
            Log.w((String)this.TAG, (String)("reflectResource() Resource '" + fieldName + "' not available! (" + error + ")"));
        }
        return defaultValue;
    }

    private static String getResourceLocation(ResourceType type) {
        return ".R." + type.getResourceName();
    }
}

