/*
 * Decompiled with CFR 0.152.
 */
package uk.co.alt236.resourcemirror.reflectors.base;

import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.alt236.resourcemirror.containers.LruLinkedHashMap;
import uk.co.alt236.resourcemirror.reflectors.base.ReflectionCore;
import uk.co.alt236.resourcemirror.reflectors.base.ResourceKeyFormatter;
import uk.co.alt236.resourcemirror.reflectors.base.ResourceReflector;

public abstract class AbstractResourceReflector
implements ResourceReflector {
    private static final boolean TIME_LOGGING_ENABLED = false;
    private static final int CACHE_SIZE = 100;
    protected final ResourceKeyFormatter mKeyFormatter;
    private final AtomicBoolean mLogErrors;
    private final ReflectionCore mReflectionCore;
    private final Map<String, Integer> mCache;
    private final Set<String> mCacheMisses;

    protected AbstractResourceReflector(String packageName) {
        this.mReflectionCore = new ReflectionCore(packageName);
        this.mKeyFormatter = new ResourceKeyFormatter();
        this.mCache = new LruLinkedHashMap<String, Integer>(100, 0.75f);
        this.mCacheMisses = new HashSet<String>(100, 0.75f);
        this.mLogErrors = new AtomicBoolean(false);
    }

    private void addToCache(@NonNull String key, @NonNull Integer value) {
        this.mCache.put(key, value);
    }

    private synchronized int fetchResourceId(@NonNull String resourceName, int fallbackResourceId) {
        Integer result;
        long startTime = System.nanoTime();
        if (this.mCacheMisses.contains(resourceName)) {
            result = fallbackResourceId;
        } else {
            result = this.getFromCache(resourceName);
            if (result == null) {
                result = this.getReflectionCore().reflectResource(this.getResourceType(), resourceName, fallbackResourceId, this.isErrorLoggingEnabled());
                if (result != fallbackResourceId) {
                    this.addToCache(resourceName, result);
                } else {
                    this.mCacheMisses.add(resourceName);
                }
            }
        }
        return result;
    }

    @NonNull
    public List<String> getAllResourceTypes() {
        return this.mReflectionCore.getResourceTypes();
    }

    @Nullable
    protected Integer getFromCache(String key) {
        return this.mCache.get(key);
    }

    @NonNull
    protected abstract String getLogTag();

    protected ReflectionCore getReflectionCore() {
        return this.mReflectionCore;
    }

    @Override
    public int getResourceId(@NonNull String resourceName) {
        return this.getResourceId(resourceName, null);
    }

    @Override
    public int getResourceId(@NonNull String resourceName, String family) {
        int resourceId = this.optResourceId(resourceName, family, -1);
        if (resourceId == -1) {
            throw new Resources.NotFoundException(this.mKeyFormatter.formatKey(resourceName, family));
        }
        return resourceId;
    }

    @Override
    @NonNull
    public List<String> getResourceList() {
        return this.mReflectionCore.getResourceList(this.getResourceType());
    }

    public boolean isErrorLoggingEnabled() {
        return this.mLogErrors.get();
    }

    @Override
    public int optResourceId(@NonNull String resourceName, int fallbackResourceId) {
        return this.optResourceId(resourceName, null, fallbackResourceId);
    }

    @Override
    public int optResourceId(@NonNull String resourceName, @Nullable String family, int fallbackResourceId) {
        return this.fetchResourceId(this.mKeyFormatter.formatKey(resourceName, family), fallbackResourceId);
    }

    public void printResourcesToLogCat() {
        this.getReflectionCore().logFields(this.getResourceType());
    }

    public void setLogErrors(boolean enable) {
        this.mLogErrors.set(enable);
    }
}

