/*
 * Decompiled with CFR 0.152.
 */
package uk.co.alt236.resourcemirror.reflectors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.co.alt236.resourcemirror.ResourceType;
import uk.co.alt236.resourcemirror.reflectors.AnimationReflector;
import uk.co.alt236.resourcemirror.reflectors.AnimatorReflector;
import uk.co.alt236.resourcemirror.reflectors.ArrayLoaderReflector;
import uk.co.alt236.resourcemirror.reflectors.AttrReflector;
import uk.co.alt236.resourcemirror.reflectors.BooleanReflector;
import uk.co.alt236.resourcemirror.reflectors.ColorReflector;
import uk.co.alt236.resourcemirror.reflectors.DimenReflector;
import uk.co.alt236.resourcemirror.reflectors.DrawableReflector;
import uk.co.alt236.resourcemirror.reflectors.FractionReflector;
import uk.co.alt236.resourcemirror.reflectors.IdReflector;
import uk.co.alt236.resourcemirror.reflectors.IntegerReflector;
import uk.co.alt236.resourcemirror.reflectors.InterpolatorReflector;
import uk.co.alt236.resourcemirror.reflectors.LayoutReflector;
import uk.co.alt236.resourcemirror.reflectors.MenuReflector;
import uk.co.alt236.resourcemirror.reflectors.MipMapReflector;
import uk.co.alt236.resourcemirror.reflectors.PluralsReflector;
import uk.co.alt236.resourcemirror.reflectors.RawReflector;
import uk.co.alt236.resourcemirror.reflectors.StringReflector;
import uk.co.alt236.resourcemirror.reflectors.StyleReflector;
import uk.co.alt236.resourcemirror.reflectors.StyleableReflector;
import uk.co.alt236.resourcemirror.reflectors.XmlReflector;
import uk.co.alt236.resourcemirror.reflectors.base.AbstractResourceReflector;
import uk.co.alt236.resourcemirror.reflectors.base.ResourceReflector;

public class ReflectorFactory {
    private final Object mResourceLoaderCreationLock = new Object();
    private final Map<ResourceType, AbstractResourceReflector> mResourceLoaders;
    private final String mPackageName;

    public ReflectorFactory(String packageName) {
        this.mPackageName = packageName;
        this.mResourceLoaders = new HashMap<ResourceType, AbstractResourceReflector>();
    }

    public ResourceReflector get(ResourceType resource) {
        AbstractResourceReflector retVal;
        if (resource == null) {
            throw new IllegalArgumentException("Cannot have null as a resource type...");
        }
        switch (resource) {
            case ANIM: {
                retVal = this.getAnimations();
                break;
            }
            case ANIMATOR: {
                retVal = this.getAnimators();
                break;
            }
            case ARRAY: {
                retVal = this.getArrays();
                break;
            }
            case ATTR: {
                retVal = this.getAttrs();
                break;
            }
            case BOOL: {
                retVal = this.getBooleans();
                break;
            }
            case COLOR: {
                retVal = this.getColors();
                break;
            }
            case DIMEN: {
                retVal = this.getDimens();
                break;
            }
            case DRAWABLE: {
                retVal = this.getDrawables();
                break;
            }
            case FRACTION: {
                retVal = this.getFractions();
                break;
            }
            case ID: {
                retVal = this.getIds();
                break;
            }
            case INTEGER: {
                retVal = this.getIntegers();
                break;
            }
            case INTERPOLATOR: {
                retVal = this.getInterpolators();
                break;
            }
            case LAYOUT: {
                retVal = this.getLayouts();
                break;
            }
            case MENU: {
                retVal = this.getMenus();
                break;
            }
            case MIPMAP: {
                retVal = this.getMipMaps();
                break;
            }
            case PLURALS: {
                retVal = this.getPlurals();
                break;
            }
            case RAW: {
                retVal = this.getRaws();
                break;
            }
            case STRING: {
                retVal = this.getStrings();
                break;
            }
            case STYLEABLE: {
                retVal = this.getStyleables();
                break;
            }
            case STYLE: {
                retVal = this.getStyles();
                break;
            }
            case XML: {
                retVal = this.getXmls();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown resource type '" + (Object)((Object)resource) + "'");
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimationReflector getAnimations() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.ANIM;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new AnimationReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (AnimationReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimatorReflector getAnimators() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.ANIMATOR;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new AnimatorReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (AnimatorReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayLoaderReflector getArrays() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.ARRAY;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new ArrayLoaderReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (ArrayLoaderReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttrReflector getAttrs() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.ATTR;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new AttrReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (AttrReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BooleanReflector getBooleans() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.BOOL;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new BooleanReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (BooleanReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorReflector getColors() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.COLOR;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new ColorReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (ColorReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimenReflector getDimens() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.DIMEN;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new DimenReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (DimenReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawableReflector getDrawables() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.DRAWABLE;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new DrawableReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (DrawableReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FractionReflector getFractions() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.FRACTION;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new FractionReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (FractionReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdReflector getIds() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.ID;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new IdReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (IdReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegerReflector getIntegers() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.INTEGER;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new IntegerReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (IntegerReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpolatorReflector getInterpolators() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.INTERPOLATOR;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new InterpolatorReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (InterpolatorReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutReflector getLayouts() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.LAYOUT;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new LayoutReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (LayoutReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuReflector getMenus() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.MENU;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new MenuReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (MenuReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MipMapReflector getMipMaps() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.MIPMAP;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new MipMapReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (MipMapReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralsReflector getPlurals() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.PLURALS;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new PluralsReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (PluralsReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawReflector getRaws() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.RAW;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new RawReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (RawReflector)methodResult;
    }

    public List<String> getResourceTypes() {
        return this.getDrawables().getAllResourceTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringReflector getStrings() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.STRING;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new StringReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (StringReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleableReflector getStyleables() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.STYLEABLE;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new StyleableReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (StyleableReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleReflector getStyles() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.STYLE;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new StyleReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (StyleReflector)methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlReflector getXmls() {
        AbstractResourceReflector methodResult;
        ResourceType type = ResourceType.XML;
        Object object = this.mResourceLoaderCreationLock;
        synchronized (object) {
            if (!this.mResourceLoaders.containsKey((Object)type)) {
                this.mResourceLoaders.put(type, new XmlReflector(this.mPackageName));
            }
            methodResult = this.mResourceLoaders.get((Object)type);
        }
        return (XmlReflector)methodResult;
    }
}

