/*
 * Decompiled with CFR 0.152.
 */
package uk.co.alt236.resourcemirror.reflectors;

import android.graphics.Color;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.alt236.resourcemirror.ResourceType;
import uk.co.alt236.resourcemirror.containers.DrawableResourceContainer;
import uk.co.alt236.resourcemirror.reflectors.base.AbstractResourceReflector;

public final class DrawableReflector
extends AbstractResourceReflector {
    public static final String ICON_PREFIX_BASE = "ic_";
    public static final String ICON_PREFIX_LAUNCHER = "ic_launcher_";
    public static final String ICON_PREFIX_MENU = "ic_menu_";
    public static final String ICON_PREFIX_STATUS_BAR = "ic_stat_notify_";
    public static final String ICON_PREFIX_TAB = "ic_tab_";
    public static final String ICON_PREFIX_DIALOG = "ic_dialog_";
    public static final String ICON_PREFIX_LIST = "ic_list_";
    private static final ResourceType RESOURCE_TYPE = ResourceType.DRAWABLE;
    private final String TAG = DrawableReflector.class.getSimpleName();
    private final AtomicBoolean mAddDrawableNameToContainer = new AtomicBoolean(false);

    protected DrawableReflector(String packageName) {
        super(packageName);
    }

    private DrawableResourceContainer fetchDrawableContainer(String drawableName, String color, @DrawableRes int fallbackDrawableId) {
        int res = this.optResourceId(drawableName, fallbackDrawableId);
        return new DrawableResourceContainer(this.mAddDrawableNameToContainer.get() ? drawableName : null, res, this.tryColor(color));
    }

    @Override
    @NonNull
    protected String getLogTag() {
        return this.TAG;
    }

    @Override
    @NonNull
    public ResourceType getResourceType() {
        return RESOURCE_TYPE;
    }

    @DrawableRes
    public int optDialogDrawable(String drawableName, String family, @DrawableRes int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_DIALOG, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optDialogDrawableContainer(String drawableName, String family, String colorString, @DrawableRes int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_DIALOG, drawableName, family), colorString, fallbackDrawableId);
    }

    public DrawableResourceContainer optDrawableContainer(String drawableName, String colorString, @DrawableRes int fallbackDrawableId) {
        return this.optDrawableContainer(drawableName, null, colorString, fallbackDrawableId);
    }

    public DrawableResourceContainer optDrawableContainer(String drawableName, String family, String colorString, @DrawableRes int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(drawableName, family), colorString, fallbackDrawableId);
    }

    public DrawableResourceContainer optLauncherDrawableContainer(String drawableName, String family, String colorString, @DrawableRes int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_LAUNCHER, drawableName, family), colorString, fallbackDrawableId);
    }

    @DrawableRes
    public int optLauncherDrawableId(String drawableName, String family, @DrawableRes int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_LAUNCHER, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optListDrawableContainer(String drawableName, String family, String colorString, @DrawableRes int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_LIST, drawableName, family), colorString, fallbackDrawableId);
    }

    @DrawableRes
    public int optListDrawableId(String drawableName, String family, @DrawableRes int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_LIST, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optMenuDrawableContainer(String drawableName, String family, String colorString, @DrawableRes int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_MENU, drawableName, family), colorString, fallbackDrawableId);
    }

    @DrawableRes
    public int optMenuDrawableId(String drawableName, String family, @DrawableRes int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_MENU, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optStatusBarDrawableContainer(String drawableName, String family, String colorString, @DrawableRes int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_STATUS_BAR, drawableName, family), colorString, fallbackDrawableId);
    }

    @DrawableRes
    public int optStatusBarDrawableId(String drawableName, String family, @DrawableRes int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_STATUS_BAR, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optTabDrawableContainer(String drawableName, String family, String colorString, @DrawableRes int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_TAB, drawableName, family), colorString, fallbackDrawableId);
    }

    @DrawableRes
    public int optTabDrawableId(String drawableName, String family, @DrawableRes int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_TAB, drawableName, family), fallbackDrawableId);
    }

    public synchronized void setAddDrawableNameToContainer(boolean enable) {
        this.mAddDrawableNameToContainer.set(enable);
    }

    @Override
    @DrawableRes
    public int getResourceId(@NonNull String resourceName) {
        return super.getResourceId(resourceName);
    }

    @Override
    @DrawableRes
    public int getResourceId(@NonNull String resourceName, String family) {
        return super.getResourceId(resourceName, family);
    }

    @Override
    @DrawableRes
    public int optResourceId(@NonNull String resourceName, @DrawableRes int fallbackResourceId) {
        return super.optResourceId(resourceName, fallbackResourceId);
    }

    @Override
    @DrawableRes
    public int optResourceId(@NonNull String resourceName, @Nullable String family, @DrawableRes int fallbackResourceId) {
        return super.optResourceId(resourceName, family, fallbackResourceId);
    }

    private Integer tryColor(String colorString) {
        if (colorString == null || colorString.length() < 1) {
            return null;
        }
        try {
            return Color.parseColor((String)colorString);
        }
        catch (IllegalArgumentException e) {
            if (this.isErrorLoggingEnabled()) {
                Log.w((String)this.TAG, (String)("tryColor() - IllegalArgumentException while trying to parse color '" + colorString + "'"));
            }
            return null;
        }
    }
}

