/*
 * Decompiled with CFR 0.152.
 */
package uk.co.alt236.resourcemirror;

import android.content.Context;
import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.co.alt236.resourcemirror.ResourceType;
import uk.co.alt236.resourcemirror.reflectors.AnimationReflector;
import uk.co.alt236.resourcemirror.reflectors.AnimatorReflector;
import uk.co.alt236.resourcemirror.reflectors.ArrayLoaderReflector;
import uk.co.alt236.resourcemirror.reflectors.AttrReflector;
import uk.co.alt236.resourcemirror.reflectors.BooleanReflector;
import uk.co.alt236.resourcemirror.reflectors.ColorReflector;
import uk.co.alt236.resourcemirror.reflectors.DimenReflector;
import uk.co.alt236.resourcemirror.reflectors.DrawableReflector;
import uk.co.alt236.resourcemirror.reflectors.FractionReflector;
import uk.co.alt236.resourcemirror.reflectors.IdReflector;
import uk.co.alt236.resourcemirror.reflectors.IntegerReflector;
import uk.co.alt236.resourcemirror.reflectors.InterpolatorReflector;
import uk.co.alt236.resourcemirror.reflectors.LayoutReflector;
import uk.co.alt236.resourcemirror.reflectors.MenuReflector;
import uk.co.alt236.resourcemirror.reflectors.MipMapReflector;
import uk.co.alt236.resourcemirror.reflectors.PluralsReflector;
import uk.co.alt236.resourcemirror.reflectors.RawReflector;
import uk.co.alt236.resourcemirror.reflectors.ReflectorFactory;
import uk.co.alt236.resourcemirror.reflectors.StringReflector;
import uk.co.alt236.resourcemirror.reflectors.StyleReflector;
import uk.co.alt236.resourcemirror.reflectors.StyleableReflector;
import uk.co.alt236.resourcemirror.reflectors.XmlReflector;
import uk.co.alt236.resourcemirror.reflectors.base.ResourceReflector;

public class Mirror {
    private static final Object MAP_LOCK = new Object();
    private static final Map<String, Mirror> MAP_OF_MIRRORS = new HashMap<String, Mirror>();
    private final ReflectorFactory mReflectorFactory;
    private final String mPackageName;

    private Mirror(@NonNull String packageName) {
        this.mPackageName = packageName;
        this.mReflectorFactory = new ReflectorFactory(this.mPackageName);
    }

    public ResourceReflector get(@NonNull ResourceType resource) {
        return this.mReflectorFactory.get(resource);
    }

    @NonNull
    public AnimationReflector getAnimations() {
        return this.mReflectorFactory.getAnimations();
    }

    @NonNull
    public AnimatorReflector getAnimators() {
        return this.mReflectorFactory.getAnimators();
    }

    @NonNull
    public ArrayLoaderReflector getArrays() {
        return this.mReflectorFactory.getArrays();
    }

    @NonNull
    public AttrReflector getAttrs() {
        return this.mReflectorFactory.getAttrs();
    }

    @NonNull
    public BooleanReflector getBooleans() {
        return this.mReflectorFactory.getBooleans();
    }

    @NonNull
    public ColorReflector getColors() {
        return this.mReflectorFactory.getColors();
    }

    @NonNull
    public DimenReflector getDimens() {
        return this.mReflectorFactory.getDimens();
    }

    @NonNull
    public DrawableReflector getDrawables() {
        return this.mReflectorFactory.getDrawables();
    }

    @NonNull
    public FractionReflector getFractions() {
        return this.mReflectorFactory.getFractions();
    }

    @NonNull
    public IdReflector getIds() {
        return this.mReflectorFactory.getIds();
    }

    @NonNull
    public IntegerReflector getIntegers() {
        return this.mReflectorFactory.getIntegers();
    }

    @NonNull
    public InterpolatorReflector getInterpolators() {
        return this.mReflectorFactory.getInterpolators();
    }

    @NonNull
    public LayoutReflector getLayouts() {
        return this.mReflectorFactory.getLayouts();
    }

    @NonNull
    public MenuReflector getMenus() {
        return this.mReflectorFactory.getMenus();
    }

    @NonNull
    public MipMapReflector getMipMaps() {
        return this.mReflectorFactory.getMipMaps();
    }

    @NonNull
    public PluralsReflector getPlurals() {
        return this.mReflectorFactory.getPlurals();
    }

    @NonNull
    public RawReflector getRaws() {
        return this.mReflectorFactory.getRaws();
    }

    @NonNull
    public StringReflector getStrings() {
        return this.mReflectorFactory.getStrings();
    }

    @NonNull
    public StyleableReflector getStyleables() {
        return this.mReflectorFactory.getStyleables();
    }

    @NonNull
    public StyleReflector getStyles() {
        return this.mReflectorFactory.getStyles();
    }

    @NonNull
    public XmlReflector getXmls() {
        return this.mReflectorFactory.getXmls();
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public List<String> getResourceTypes() {
        return this.getDrawables().getAllResourceTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = MAP_LOCK;
        synchronized (object) {
            MAP_OF_MIRRORS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfMirrors() {
        Object object = MAP_LOCK;
        synchronized (object) {
            return MAP_OF_MIRRORS.size();
        }
    }

    @NonNull
    public static Mirror of(@NonNull Context context) {
        return Mirror.of(Mirror.getPackageName(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Mirror of(@NonNull String packageName) {
        Object object = MAP_LOCK;
        synchronized (object) {
            if (!MAP_OF_MIRRORS.containsKey(packageName)) {
                MAP_OF_MIRRORS.put(packageName, new Mirror(packageName));
            }
        }
        return MAP_OF_MIRRORS.get(packageName);
    }

    public static String getPackageName(@NonNull Context context) {
        return context.getApplicationContext().getPackageName();
    }
}

