/*
 * Decompiled with CFR 0.152.
 */
package gate.test;

import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.Plugin;
import gate.test.GATEPluginTestCase;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashSet;

public abstract class GappLoadingTestCase
extends GATEPluginTestCase {
    String[] excluded = null;

    public GappLoadingTestCase(String ... excluded) {
        this.excluded = excluded;
    }

    public void testGappLoading() throws Exception {
        PrintWriter out;
        URL creoleURL = ((Object)((Object)this)).getClass().getResource("/creole.xml");
        URL resourcesURL = new URL(creoleURL, "resources");
        Path pathInPlugin = Paths.get(resourcesURL.toURI());
        if (Files.exists(pathInPlugin, new LinkOption[0])) {
            Files.walkFileTree(pathInPlugin, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                    String filename = filePath.getFileName().toString().toLowerCase();
                    if (filename.endsWith(".gapp") || filename.endsWith(".xgapp")) {
                        boolean shouldTest = true;
                        String[] stringArray = GappLoadingTestCase.this.excluded;
                        int n = GappLoadingTestCase.this.excluded.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String exclude = stringArray[n2];
                            shouldTest &= !filePath.endsWith(exclude);
                            ++n2;
                        }
                        if (shouldTest) {
                            System.out.println("Trying to load " + filePath);
                            Object obj = null;
                            try {
                                try {
                                    obj = PersistenceManager.loadObjectFromFile((File)filePath.toFile());
                                }
                                catch (Exception e) {
                                    throw new IOException(e);
                                }
                            }
                            finally {
                                if (obj instanceof Resource) {
                                    Factory.deleteResource((Resource)((Resource)obj));
                                }
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        LinkedHashSet plugins = new LinkedHashSet(Gate.getCreoleRegister().getPlugins());
        Throwable throwable = null;
        Object var6_8 = null;
        try {
            out = new PrintWriter(new File(gate.util.Files.fileFromURL((URL)creoleURL).getParentFile().getParentFile(), "creole-dependencies.txt"));
            try {
                out.println(GappLoadingTestCase.generatePluginLabel((Plugin)this.pluginUnderTest));
                for (Plugin plugin : Gate.getCreoleRegister().getPlugins()) {
                    if (!plugin.equals((Object)this.pluginUnderTest)) {
                        out.println(GappLoadingTestCase.generatePluginLabel(plugin));
                    }
                    for (Plugin required : plugin.getRequiredPlugins()) {
                        plugins.remove(required);
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var6_8 = null;
        try {
            out = new PrintWriter(new File(gate.util.Files.fileFromURL((URL)creoleURL).getParentFile().getParentFile(), "creole-dependencies.gv"));
            try {
                out.println("digraph G {");
                out.println("   // ensure we always include this plugin even if no dependencies");
                out.println("   \"" + GappLoadingTestCase.generatePluginLabel((Plugin)this.pluginUnderTest) + "\"\n");
                for (Plugin plugin : plugins) {
                    GappLoadingTestCase.dumpPluginHierarchy(out, plugin, "[color=red]");
                    if (plugin.equals((Object)this.pluginUnderTest)) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("   \"").append(GappLoadingTestCase.generatePluginLabel((Plugin)this.pluginUnderTest)).append("\" -> \"").append(GappLoadingTestCase.generatePluginLabel(plugin)).append("\" [color=green]\n");
                    out.println(builder.toString());
                }
                out.println("}");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void dumpPluginHierarchy(PrintWriter out, Plugin plugin, String formatting) {
        StringBuilder builder = new StringBuilder();
        for (Plugin required : plugin.getRequiredPlugins()) {
            builder.append("   \"").append(GappLoadingTestCase.generatePluginLabel(plugin)).append("\" -> \"").append(GappLoadingTestCase.generatePluginLabel(required)).append("\"");
            if (formatting != null && !formatting.isEmpty()) {
                builder.append(" ").append(formatting);
            }
            builder.append("\n");
        }
        out.print(builder.toString());
    }

    private static String generatePluginLabel(Plugin plugin) {
        StringBuilder builder = new StringBuilder();
        if (plugin instanceof Plugin.Maven) {
            Plugin.Maven mavenPlugin = (Plugin.Maven)plugin;
            builder.append(mavenPlugin.getGroup()).append(":").append(mavenPlugin.getArtifact()).append(":").append(mavenPlugin.getVersion());
        } else {
            builder.append(plugin.getClass()).append(":").append(plugin.getName()).append(":").append(plugin.getVersion());
        }
        return builder.toString();
    }
}

