/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.player.misc;

import android.text.TextUtils;
import tv.danmaku.ijk.media.player.IjkMediaMeta;
import tv.danmaku.ijk.media.player.misc.IMediaFormat;
import tv.danmaku.ijk.media.player.misc.ITrackInfo;
import tv.danmaku.ijk.media.player.misc.IjkMediaFormat;

public class IjkTrackInfo
implements ITrackInfo {
    private int mTrackType = 0;
    private IjkMediaMeta.IjkStreamMeta mStreamMeta;

    public IjkTrackInfo(IjkMediaMeta.IjkStreamMeta streamMeta) {
        this.mStreamMeta = streamMeta;
    }

    public void setMediaMeta(IjkMediaMeta.IjkStreamMeta streamMeta) {
        this.mStreamMeta = streamMeta;
    }

    @Override
    public IMediaFormat getFormat() {
        return new IjkMediaFormat(this.mStreamMeta);
    }

    @Override
    public String getLanguage() {
        if (this.mStreamMeta == null || TextUtils.isEmpty((CharSequence)this.mStreamMeta.mLanguage)) {
            return "und";
        }
        return this.mStreamMeta.mLanguage;
    }

    @Override
    public int getTrackType() {
        return this.mTrackType;
    }

    public void setTrackType(int trackType) {
        this.mTrackType = trackType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.getInfoInline() + "}";
    }

    @Override
    public String getInfoInline() {
        StringBuilder out = new StringBuilder(128);
        switch (this.mTrackType) {
            case 1: {
                out.append("VIDEO");
                out.append(", ");
                out.append(this.mStreamMeta.getCodecShortNameInline());
                out.append(", ");
                out.append(this.mStreamMeta.getBitrateInline());
                out.append(", ");
                out.append(this.mStreamMeta.getResolutionInline());
                break;
            }
            case 2: {
                out.append("AUDIO");
                out.append(", ");
                out.append(this.mStreamMeta.getCodecShortNameInline());
                out.append(", ");
                out.append(this.mStreamMeta.getBitrateInline());
                out.append(", ");
                out.append(this.mStreamMeta.getSampleRateInline());
                break;
            }
            case 3: {
                out.append("TIMEDTEXT");
                break;
            }
            case 4: {
                out.append("SUBTITLE");
                break;
            }
            default: {
                out.append("UNKNOWN");
            }
        }
        return out.toString();
    }
}

