/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.security;

import com.binance.api.client.security.HmacSHA256Signer;
import java.io.IOException;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.commons.lang3.StringUtils;

public class AuthenticationInterceptor
implements Interceptor {
    private final String apiKey;
    private final String secret;

    public AuthenticationInterceptor(String apiKey, String secret) {
        this.apiKey = apiKey;
        this.secret = secret;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String payload;
        Request original = chain.request();
        Request.Builder newRequestBuilder = original.newBuilder();
        boolean isApiKeyRequired = original.header("APIKEY") != null;
        boolean isSignatureRequired = original.header("SIGNED") != null;
        newRequestBuilder.removeHeader("APIKEY").removeHeader("SIGNED");
        if (isApiKeyRequired || isSignatureRequired) {
            newRequestBuilder.addHeader("X-MBX-APIKEY", this.apiKey);
        }
        if (isSignatureRequired && !StringUtils.isEmpty((CharSequence)(payload = original.url().query()))) {
            String signature = HmacSHA256Signer.sign(payload, this.secret);
            HttpUrl signedUrl = original.url().newBuilder().addQueryParameter("signature", signature).build();
            newRequestBuilder.url(signedUrl);
        }
        Request newRequest = newRequestBuilder.build();
        return chain.proceed(newRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String bodyToString(RequestBody request) {
        try (Buffer buffer = new Buffer();){
            RequestBody copy = request;
            if (copy != null) {
                copy.writeTo((BufferedSink)buffer);
                String string = buffer.readUtf8();
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationInterceptor that = (AuthenticationInterceptor)o;
        return Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.secret, that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.secret);
    }
}

