/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.tracker;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.messengers.Messenger;
import tr.com.infumia.infumialib.proto.Messaging;
import tr.com.infumia.infumialib.proto.Player;
import tr.com.infumia.infumialib.tracker.PlayerListener;

public interface PlayerTracker {
    @NotNull
    public static PlayerTracker simple(@NotNull Messenger messenger) {
        return new Impl(messenger);
    }

    public void addUser(@NotNull Definition.NonPositionalNetworkUser var1);

    public void register(@NotNull PlayerListener var1);

    public void removeUser(@NotNull String var1);

    default public void removeUser(@NotNull Definition.NonPositionalNetworkUser user) {
        this.removeUser(user.user().id());
    }

    @NotNull
    public Optional<Definition.NonPositionalNetworkUser> user(@NotNull String var1);

    @NotNull
    public Collection<Definition.NonPositionalNetworkUser> users();

    public static final class Impl
    implements PlayerTracker {
        @NotNull
        private final Collection<PlayerListener> listeners = new HashSet<PlayerListener>();
        @NotNull
        private final Object2ObjectMap<String, Definition.NonPositionalNetworkUser> users = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());

        private Impl(@NotNull Messenger messenger) {
            messenger.subscribe(Player.LoginEvent.getDefaultInstance(), this::onLogin);
            messenger.subscribe(Player.QuitEvent.getDefaultInstance(), this::onQuit);
        }

        @Override
        public void addUser(@NotNull Definition.NonPositionalNetworkUser user) {
            this.users.put((Object)user.user().id(), (Object)user);
        }

        @Override
        public void register(@NotNull PlayerListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeUser(@NotNull String id) {
            this.users.remove((Object)id);
        }

        @Override
        @NotNull
        public Optional<Definition.NonPositionalNetworkUser> user(@NotNull String id) {
            return Optional.ofNullable((Definition.NonPositionalNetworkUser)this.users.get((Object)id));
        }

        @Override
        @NotNull
        public Collection<Definition.NonPositionalNetworkUser> users() {
            return this.users.values();
        }

        private void onLogin(@NotNull Messaging.ServerMessage serverMessage, @NotNull Player.LoginEvent event) {
            if (!event.getFirstSeen()) {
                return;
            }
            Definition.NonPositionalNetworkUser user = Definition.NonPositionalNetworkUser.of(event.getUser());
            this.addUser(user);
            this.listeners.forEach(listener -> {
                try {
                    listener.onRegister(user);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }

        private void onQuit(@NotNull Messaging.ServerMessage serverMessage, @NotNull Player.QuitEvent event) {
            Definition.NonPositionalNetworkUser user = Definition.NonPositionalNetworkUser.of(event.getUser());
            this.removeUser(user);
            this.listeners.forEach(listener -> {
                try {
                    listener.onUnregister(user);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

