/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity.multiserver;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.messengers.ProxyMessenger;
import tr.com.infumia.infumialib.tracker.ServerTracker;

public final class ProxySynchronizer
implements Runnable {
    @NotNull
    private final Definition.ServerInfo info;
    @NotNull
    private final ServerTracker serverTracker;

    public ProxySynchronizer(@NotNull ProxyServer server, @NotNull String id, @NotNull ServerTracker serverTracker) {
        this(Definition.ServerInfo.of(Definition.Server.of("proxy-" + id, id, "proxy"), (String)GsonComponentSerializer.gson().serializeOr(server.getConfiguration().getMotd(), (Object)"Fallback MOTD!"), server.getBoundAddress().getHostName(), server.getBoundAddress().getPort(), -1, System.currentTimeMillis(), -1.0, -1.0), serverTracker);
    }

    public ProxySynchronizer(@NotNull ProxyServer server, @NotNull ServerTracker serverTracker) {
        this(server, UUID.randomUUID().toString(), serverTracker);
    }

    @Subscribe
    public void onPing(ProxyPingEvent event) {
        event.setPing(event.getPing().asBuilder().onlinePlayers(this.serverTracker.servers().asMap().values().stream().mapToInt(Definition.PlayerCount::playerCount).filter(value -> value >= 1).sum()).build());
    }

    @Override
    public void run() {
        ConcurrentMap map = this.serverTracker.servers().asMap();
        System.out.printf("Server cache size: %s, Server caches: %s%n", map.size(), map.keySet());
        ProxyMessenger.get().publish("proxy", this.info.toProto());
    }

    public ProxySynchronizer(@NotNull Definition.ServerInfo info, @NotNull ServerTracker serverTracker) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (serverTracker == null) {
            throw new NullPointerException("serverTracker is marked non-null but is null");
        }
        this.info = info;
        this.serverTracker = serverTracker;
    }
}

