/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity.files;

import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import tr.com.infumia.infumialib.configurate.InfumiaCollection;

@ConfigSerializable
public final class VelocityConfig {
    @NotNull
    private static VelocityConfig INSTANCE = new VelocityConfig();
    @Setting
    @Comment(value="Checks update for the Infumia library plugin.")
    private boolean checkForUpdate = true;
    @Setting
    @Comment(value="Whether enable multiple server support or not.")
    private boolean multiServer = false;
    @Setting
    @Comment(value="Redis sentinel password.")
    private String redisPassword = "password";

    public static void init(@NotNull Path directory) throws ConfigurateException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(directory.resolve("velocity.conf"))).defaultOptions(options -> options.implicitInitialization(false).serializers(builder -> builder.registerAll(InfumiaCollection.COLLECTION)))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        VelocityConfig config = (VelocityConfig)node.get(VelocityConfig.class, (Object)new VelocityConfig());
        node.set(VelocityConfig.class, (Object)config);
        loader.save((ConfigurationNode)node);
        INSTANCE = config;
    }

    @NotNull
    public static VelocityConfig instance() {
        return INSTANCE;
    }

    public boolean checkForUpdate() {
        return this.checkForUpdate;
    }

    public boolean multiServer() {
        return this.multiServer;
    }

    public String redisPassword() {
        return this.redisPassword;
    }

    public VelocityConfig checkForUpdate(boolean checkForUpdate) {
        this.checkForUpdate = checkForUpdate;
        return this;
    }

    public VelocityConfig multiServer(boolean multiServer) {
        this.multiServer = multiServer;
        return this;
    }

    public VelocityConfig redisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }
}

