/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import tr.com.infumia.infumialib.platform.velocity.Initializer;
import tr.com.infumia.infumialib.platform.velocity.Metrics;
import tr.com.infumia.infumialib.slimjar.app.builder.ApplicationBuilder;
import tr.com.infumia.infumialib.slimjar.logging.ProcessLogger;

public final class InfumiaLib {
    @Inject
    @Named(value="infumialibraryplugin")
    private PluginContainer container;
    @Inject
    private Path dataDirectory;
    @Inject
    private Logger logger;
    @Inject
    private Metrics.Factory metricsFactory;
    @Inject
    private ProxyServer server;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.loadDependencies();
        Initializer.init(this);
    }

    private void loadDependencies() {
        this.logger.info("Loading dependencies, this might take a while...");
        try {
            ApplicationBuilder.appending("InfumiaLibrary").logger(new ProcessLogger(){

                @Override
                public void debug(String message, Object ... args) {
                    InfumiaLib.this.logger.debug(MessageFormat.format(message, args));
                }

                @Override
                public void log(String message, Object ... args) {
                    InfumiaLib.this.logger.info(MessageFormat.format(message, args));
                }
            }).downloadDirectoryPath(this.dataDirectory.resolve("libs")).build();
        }
        catch (IOException | ReflectiveOperationException | URISyntaxException | NoSuchAlgorithmException e) {
            this.logger.error(String.format("%s-v%s", this.getClass().getSimpleName(), this.container.getDescription().getVersion().orElse("")), (Throwable)e);
            this.logger.error("Infumia Library failed to load its dependencies correctly!");
            this.logger.error("This error should be reported at https://github.com/Infumia/InfumiaLib/issues");
            this.server.shutdown();
        }
    }

    public PluginContainer container() {
        return this.container;
    }

    public Path dataDirectory() {
        return this.dataDirectory;
    }

    public Logger logger() {
        return this.logger;
    }

    public Metrics.Factory metricsFactory() {
        return this.metricsFactory;
    }

    public ProxyServer server() {
        return this.server;
    }
}

