/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.dynamism;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.dynamism.Dynamic;
import tr.com.infumia.infumialib.dynamism.DynamicRegistry;
import tr.com.infumia.infumialib.misc.Jackson;

public interface DynamicStore
extends Definition.Encoded {
    @NotNull
    public static DynamicStore decode(@NotNull DynamicRegistry registry, @NotNull File file) throws IOException {
        return DynamicStore.decode(registry, (JsonNode)Jackson.JSON_MAPPER.readValue((InputStream)new FileInputStream(file), ObjectNode.class));
    }

    @NotNull
    public static DynamicStore decode(@NotNull DynamicRegistry registry, @NotNull String text) throws JsonProcessingException {
        return DynamicStore.decode(registry, (JsonNode)Jackson.JSON_MAPPER.readValue(text, ObjectNode.class));
    }

    public static void decode(@NotNull DynamicRegistry registry, @NotNull File file, @NotNull Consumer<Dynamic> consumer) throws IOException {
        DynamicStore.decode(registry, (JsonNode)Jackson.JSON_MAPPER.readValue((InputStream)new FileInputStream(file), ObjectNode.class), consumer);
    }

    public static void decode(@NotNull DynamicRegistry registry, @NotNull String text, @NotNull Consumer<Dynamic> consumer) throws JsonProcessingException {
        DynamicStore.decode(registry, (JsonNode)Jackson.JSON_MAPPER.readValue(text, ObjectNode.class), consumer);
    }

    @NotNull
    public static DynamicStore decode(@NotNull DynamicRegistry registry, @NotNull JsonNode json) {
        DynamicStore store = DynamicStore.empty(registry);
        DynamicStore.decode(registry, json, store::dynamic);
        return store;
    }

    public static void decode(@NotNull DynamicRegistry registry, @NotNull JsonNode json, @NotNull Consumer<Dynamic> consumer) {
        Iterator iterator = json.fields();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            String key = (String)next.getKey();
            try {
                consumer.accept((Dynamic)Jackson.JSON_MAPPER.treeToValue((TreeNode)next.getValue(), (Class)Preconditions.checkNotNull(registry.get(key), (String)"Dynamic key %s not found!", (Object)key)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public static DynamicStore decodeOrEmpty(@NotNull DynamicRegistry registry, @NotNull String text) {
        DynamicStore settingStore;
        try {
            settingStore = DynamicStore.decode(registry, text);
        }
        catch (JsonProcessingException e) {
            settingStore = DynamicStore.empty(registry);
            e.printStackTrace();
        }
        return settingStore;
    }

    @NotNull
    public static DynamicStore empty(@NotNull DynamicRegistry registry) {
        return new Impl(registry);
    }

    @NotNull
    public static String encode(@NotNull DynamicStore store) {
        ObjectNode json = Jackson.JSON_MAPPER.createObjectNode();
        for (Dynamic next : store.dynamics()) {
            try {
                json.set((String)next.key(), Jackson.JSON_MAPPER.valueToTree((Object)next));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return json.toString();
    }

    @NotNull
    public <T extends Dynamic> T dynamic(@NotNull Class<T> var1);

    @NotNull
    public Dynamic dynamic(@NotNull String var1);

    public void dynamic(@NotNull Dynamic var1);

    @NotNull
    public Collection<Dynamic> dynamics();

    public static final class Impl
    implements DynamicStore {
        @NotNull
        private final Map<Class<? extends Dynamic>, Dynamic> dynamicsByClass = new ConcurrentHashMap<Class<? extends Dynamic>, Dynamic>();
        @NotNull
        private final Map<String, Dynamic> dynamicsByKey = new ConcurrentHashMap<String, Dynamic>();
        @NotNull
        private final DynamicRegistry registry;

        @Override
        @NotNull
        public <T extends Dynamic> T dynamic(@NotNull Class<T> cls) {
            Dynamic dynamic = this.dynamicsByClass.get(cls);
            if (dynamic == null) {
                dynamic = this.registry.create(cls);
                this.dynamic(dynamic);
            }
            return (T)dynamic;
        }

        @Override
        @NotNull
        public Dynamic dynamic(@NotNull String key) {
            Dynamic dynamic = this.dynamicsByKey.get(key);
            if (dynamic == null) {
                dynamic = this.registry.create(key);
                this.dynamic(dynamic);
            }
            return dynamic;
        }

        @Override
        public void dynamic(@NotNull Dynamic dynamic) {
            this.dynamicsByKey.put((String)dynamic.key(), dynamic);
            this.dynamicsByClass.put(dynamic.getClass(), dynamic);
        }

        @Override
        @NotNull
        public Collection<Dynamic> dynamics() {
            return this.dynamicsByKey.values();
        }

        @Override
        @NotNull
        public String encoded() {
            String encode = DynamicStore.encode(this);
            byte[] base64 = Base64.getEncoder().encode(encode.getBytes(StandardCharsets.UTF_8));
            return new String(base64, StandardCharsets.UTF_8);
        }

        private Impl(@NotNull DynamicRegistry registry) {
            if (registry == null) {
                throw new NullPointerException("registry is marked non-null but is null");
            }
            this.registry = registry;
        }
    }
}

