/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.scoreboard.line;

import java.io.Closeable;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public interface Line<O>
extends Function<O, String>,
Closeable {
    @NotNull
    public static <O> Line<O> dynamic(@NotNull @NotNull Function<@NotNull O, @NotNull String> line) {
        return new Impl<O>(line, false);
    }

    @NotNull
    public static <O> Line<O> immutable(@NotNull String line) {
        return new Impl<Object>(observer -> line, false);
    }

    @NotNull
    public static <O> Merged<O> merged(@NotNull List<Line<O>> lines) {
        return new Merged<O>(lines);
    }

    @SafeVarargs
    @NotNull
    public static <O> Merged<O> merged(Line<O> ... lines) {
        return Line.merged(List.of(lines));
    }

    @Override
    default public void close() {
    }

    public boolean isUpdate();

    public static final class Impl<O>
    implements Line<O> {
        @NotNull
        private final @NotNull Function<@NotNull O, @NotNull String> function;
        private final boolean update;

        private Impl(@NotNull @NotNull Function<@NotNull O, @NotNull String> function, boolean update) {
            if (function == null) {
                throw new NullPointerException("function is marked non-null but is null");
            }
            this.function = function;
            this.update = update;
        }

        @Override
        public boolean isUpdate() {
            return this.update;
        }

        @Override
        public String apply(O arg0) {
            return this.function.apply(arg0);
        }

        @Override
        public <V> Function<V, String> compose(Function<? super V, ? extends O> before) {
            return this.function.compose(before);
        }

        @Override
        public <V> Function<O, V> andThen(Function<? super String, ? extends V> after) {
            return this.function.andThen(after);
        }
    }

    public static final class Merged<O>
    implements Line<O> {
        @NotNull
        private final List<Line<O>> lines;

        @Override
        @NotNull
        public String apply(@NotNull O o) {
            StringJoiner joiner = new StringJoiner("");
            for (Line<O> line : this.lines) {
                joiner.add((CharSequence)line.apply(o));
            }
            return joiner.toString();
        }

        @Override
        public boolean isUpdate() {
            for (Line<O> line : this.lines) {
                if (!line.isUpdate()) continue;
                return true;
            }
            return false;
        }

        private Merged(@NotNull List<Line<O>> lines) {
            if (lines == null) {
                throw new NullPointerException("lines is marked non-null but is null");
            }
            this.lines = lines;
        }
    }

    public static abstract class Envelope<O>
    implements Line<O> {
        @NotNull
        private final Line<O> delegate;

        private Envelope(@NotNull Line<O> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean isUpdate() {
            return this.delegate.isUpdate();
        }

        @Override
        public String apply(O arg0) {
            return (String)this.delegate.apply(arg0);
        }

        @Override
        public <V> Function<V, String> compose(Function<? super V, ? extends O> before) {
            return this.delegate.compose(before);
        }

        @Override
        public <V> Function<O, V> andThen(Function<? super String, ? extends V> after) {
            return this.delegate.andThen(after);
        }
    }
}

