/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.functions;

import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.functions.FailedBiConsumer;
import tr.com.infumia.infumialib.functions.FailedConsumer;
import tr.com.infumia.infumialib.functions.FailedFunction;
import tr.com.infumia.infumialib.functions.FailedRunnable;
import tr.com.infumia.infumialib.functions.FailedSupplier;

public final class UncheckedMultiOptional<X, Y> {
    @NotNull
    private final FailedFunction<X, Y> function;
    @NotNull
    private final FailedSupplier<X> supplier;

    @NotNull
    public static <X, Y> UncheckedMultiOptional<X, Y> empty() {
        return UncheckedMultiOptional.of(() -> null, x -> null);
    }

    @NotNull
    public static <X, Y> UncheckedMultiOptional<X, Y> of(@NotNull FailedSupplier<X> supplier, @NotNull FailedFunction<X, Y> function) {
        return new UncheckedMultiOptional<X, Y>(function, supplier);
    }

    @NotNull
    public UncheckedMultiOptional<X, Y> empty(@NotNull FailedRunnable runnable, @NotNull FailedConsumer<X> consumer) {
        try {
            X x = this.supplier.get();
            if (x == null) {
                runnable.run();
            } else {
                Y y = this.function.apply(x);
                if (y == null) {
                    runnable.run();
                } else {
                    consumer.accept(x);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @NotNull
    public UncheckedMultiOptional<X, Y> present(@NotNull FailedBiConsumer<X, Y> consumer) {
        try {
            Y y;
            X x = this.supplier.get();
            if (x != null && (y = this.function.apply(x)) != null) {
                consumer.accept(x, y);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private UncheckedMultiOptional(@NotNull FailedFunction<X, Y> function, @NotNull FailedSupplier<X> supplier) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.function = function;
        this.supplier = supplier;
    }
}

