/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.sql;

import com.google.common.collect.ImmutableMap;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.jackson2.Jackson2Plugin;
import org.jdbi.v3.jodatime2.JodaTimePlugin;
import org.jdbi.v3.jpa.JpaPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.sql.SqlCredentials;

public record JdbiCreator(@NotNull SqlCredentials credentials) {
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final String DRIVER_CLASS = "org.mariadb.jdbc.Driver";
    private static final long LEAK_DETECTION_THRESHOLD = TimeUnit.SECONDS.toMillis(10L);
    private static final int MAXIMUM_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static final int MINIMUM_IDLE = 10;
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger(0);

    @NotNull
    public Jdbi create() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("infumialib-sql-" + POOL_COUNTER.getAndIncrement());
        config.setDriverClassName(DRIVER_CLASS);
        config.setJdbcUrl("jdbc:mariadb://" + this.credentials.host() + ":" + this.credentials.port() + "/" + this.credentials.database());
        config.setUsername(this.credentials.username());
        config.setPassword(this.credentials.password());
        config.setMaximumPoolSize(MAXIMUM_POOL_SIZE);
        config.setMinimumIdle(10);
        config.setMaxLifetime(MAX_LIFETIME);
        config.setConnectionTimeout(CONNECTION_TIMEOUT);
        config.setLeakDetectionThreshold(LEAK_DETECTION_THRESHOLD);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"useUnicode", (Object)"true").put((Object)"characterEncoding", (Object)"utf8").put((Object)"cachePrepStmts", (Object)"true").put((Object)"prepStmtCacheSize", (Object)"250").put((Object)"prepStmtCacheSqlLimit", (Object)"2048").put((Object)"useServerPrepStmts", (Object)"true").put((Object)"useLocalSessionState", (Object)"true").put((Object)"rewriteBatchedStatements", (Object)"true").put((Object)"cacheResultSetMetadata", (Object)"true").put((Object)"cacheServerConfiguration", (Object)"true").put((Object)"elideSetAutoCommits", (Object)"true").put((Object)"maintainTimeStats", (Object)"false").put((Object)"alwaysSendSetIsolation", (Object)"false").put((Object)"cacheCallableStmts", (Object)"true").put((Object)"socketTimeout", (Object)String.valueOf(TimeUnit.SECONDS.toMillis(30L))).build();
        properties.forEach((arg_0, arg_1) -> ((HikariConfig)config).addDataSourceProperty(arg_0, arg_1));
        return Jdbi.create((DataSource)new HikariDataSource(config)).installPlugin((JdbiPlugin)new SqlObjectPlugin()).installPlugin((JdbiPlugin)new Jackson2Plugin()).installPlugin((JdbiPlugin)new JodaTimePlugin()).installPlugin((JdbiPlugin)new JpaPlugin());
    }
}

