/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.teleport;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.messaging.proto.Definitions;
import tr.com.infumia.infumialib.registries.Registry;

public interface Teleport {
    public static final Registry<String, Sender> REGISTRY = new Registry();

    @NotNull
    public static Collection<Sender> values() {
        return REGISTRY.values();
    }

    @NotNull
    public static Optional<Sender> get(@NotNull String key) {
        return REGISTRY.get(key);
    }

    public static void register(@NotNull Sender sender) {
        REGISTRY.register(sender);
    }

    @Nullable
    default public Definitions.Error canTeleport(@NotNull Definitions.OfflineUser source, @NotNull String reason, @NotNull Definitions.Position position) {
        return Teleport.values().stream().map(sender -> sender.canTeleport(source, reason, position)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void nativeTeleport(@NotNull Definitions.OfflineUser var1, @NotNull String var2, @NotNull Definitions.Position var3, @NotNull Consumer<@Nullable Definitions.Error> var4);

    default public void teleport(@NotNull Definitions.OfflineUser source, @NotNull String reason, @NotNull Definitions.Position position, @NotNull Consumer<@Nullable Definitions.Error> consumer) {
        CompletableFuture.runAsync(() -> {
            Definitions.Error result = this.canTeleport(source, reason, position);
            if (result != null) {
                consumer.accept(result);
            }
            this.nativeTeleport(source, reason, position, consumer);
        });
    }

    public static interface Sender
    extends Definition.Key<String> {
        @Nullable
        public Definitions.Error canTeleport(@NotNull Definitions.OfflineUser var1, @NotNull String var2, @NotNull Definitions.Position var3);
    }
}

