/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.replaceable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public abstract class RpBase<S extends RpBase<S, X>, X> {
    @NotNull
    private final Collection<UnaryOperator<X>> maps = new ArrayList<UnaryOperator<X>>();
    @NotNull
    private final Collection<String> regex = new ArrayList<String>();
    @NotNull
    private final Map<String, Supplier<Object>> replaces = new HashMap<String, Supplier<Object>>();
    @NotNull
    private final X value;

    @SafeVarargs
    @NotNull
    public final X build(Map.Entry<String, Supplier<Object>> ... entries) {
        return this.build(Arrays.asList(entries));
    }

    @NotNull
    public final X build(@NotNull Collection<Map.Entry<String, Supplier<Object>>> entries) {
        HashMap<String, Supplier<Object>> map = new HashMap<String, Supplier<Object>>();
        for (Map.Entry<String, Supplier<Object>> entry : entries) {
            if (map.put(entry.getKey(), entry.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        return this.build(map);
    }

    @NotNull
    public final X build(@NotNull Map.Entry<String, Supplier<Object>> entry) {
        return this.build(Collections.singletonList(entry));
    }

    @NotNull
    public final X build(@NotNull String regex, @NotNull Supplier<Object> replace) {
        return this.build(Map.entry(regex, replace));
    }

    @NotNull
    public final X build(@NotNull Map<String, Supplier<Object>> replaces) {
        AtomicReference<X> value = new AtomicReference<X>(this.value);
        for (UnaryOperator<X> operator : this.maps) {
            value.set(operator.apply(value.get()));
        }
        this.replaces.forEach((regex, supplier) -> value.set(this.replace((X)value.get(), (CharSequence)regex, String.valueOf(supplier.get()))));
        for (String s : this.regex) {
            if (!replaces.containsKey(s)) continue;
            value.set(this.replace(value.get(), s, String.valueOf(replaces.get(s).get())));
        }
        return value.get();
    }

    @NotNull
    public final <Y> Y buildMap(@NotNull Function<X, Y> function, @NotNull Map<String, Supplier<Object>> replaces) {
        return function.apply(this.build(replaces));
    }

    @SafeVarargs
    @NotNull
    public final <Y> Y buildMap(@NotNull Function<X, Y> function, Map.Entry<String, Supplier<Object>> ... replaces) {
        return function.apply(this.build(replaces));
    }

    @NotNull
    public final S map(@NotNull Collection<UnaryOperator<X>> map) {
        this.maps.addAll(map);
        return this.self();
    }

    @SafeVarargs
    @NotNull
    public final S map(UnaryOperator<X> ... maps) {
        return this.map(List.of(maps));
    }

    @NotNull
    public final S regex(@NotNull Collection<String> regex) {
        this.regex.addAll(regex);
        return this.self();
    }

    @NotNull
    public final S regex(String ... regex) {
        return this.regex(Arrays.asList(regex));
    }

    @NotNull
    public final S replace(@NotNull Map<String, Supplier<Object>> replaces) {
        this.replaces.putAll(replaces);
        return this.self();
    }

    @SafeVarargs
    @NotNull
    public final S replace(Map.Entry<String, Supplier<Object>> ... replaces) {
        for (Map.Entry<String, Supplier<Object>> entry : replaces) {
            this.replaces.put(entry.getKey(), entry.getValue());
        }
        return this.self();
    }

    @NotNull
    public final S replace(@NotNull String regex, @NotNull Supplier<Object> replace) {
        return this.replace(Collections.singletonMap(regex, replace));
    }

    @NotNull
    public final S value(@NotNull X value) {
        return ((RpBase)((RpBase)((RpBase)this.newSelf(value).get()).regex(this.getRegex())).replace(this.getReplaces())).map(this.getMaps());
    }

    @NotNull
    protected abstract Supplier<S> newSelf(@NotNull X var1);

    @NotNull
    protected abstract X replace(@NotNull X var1, @NotNull CharSequence var2, @NotNull CharSequence var3);

    protected abstract S self();

    public String toString() {
        return "RpBase(maps=" + this.getMaps() + ", regex=" + this.getRegex() + ", replaces=" + this.getReplaces() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpBase)) {
            return false;
        }
        RpBase other = (RpBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<UnaryOperator<X>> this$maps = this.getMaps();
        Collection<UnaryOperator<X>> other$maps = other.getMaps();
        if (this$maps == null ? other$maps != null : !((Object)this$maps).equals(other$maps)) {
            return false;
        }
        Collection<String> this$regex = this.getRegex();
        Collection<String> other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Map<String, Supplier<Object>> this$replaces = this.getReplaces();
        Map<String, Supplier<Object>> other$replaces = other.getReplaces();
        if (this$replaces == null ? other$replaces != null : !((Object)this$replaces).equals(other$replaces)) {
            return false;
        }
        X this$value = this.getValue();
        X other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<UnaryOperator<X>> $maps = this.getMaps();
        result = result * 59 + ($maps == null ? 43 : ((Object)$maps).hashCode());
        Collection<String> $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Map<String, Supplier<Object>> $replaces = this.getReplaces();
        result = result * 59 + ($replaces == null ? 43 : ((Object)$replaces).hashCode());
        X $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public RpBase(@NotNull X value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @NotNull
    public Collection<UnaryOperator<X>> getMaps() {
        return this.maps;
    }

    @NotNull
    public Collection<String> getRegex() {
        return this.regex;
    }

    @NotNull
    public Map<String, Supplier<Object>> getReplaces() {
        return this.replaces;
    }

    @NotNull
    public X getValue() {
        return this.value;
    }
}

