/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HtmlUtil {
    public static void writerJson(HttpServletResponse response, String data) {
        response.setContentType("application/json");
        HtmlUtil.writer(response, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writer(HttpServletResponse response, String data) {
        PrintWriter out = null;
        try {
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setCharacterEncoding("UTF-8");
            out = response.getWriter();
            out.print(data);
            out.flush();
            IOUtils.closeQuietly((Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static String getIP(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static Boolean isAjax(HttpServletRequest request) {
        String header = request.getHeader("X-Requested-With");
        if (header == null) {
            return false;
        }
        if (header.equals("XMLHttpRequest")) {
            return true;
        }
        return false;
    }

    public static String getFilePath(HttpServletRequest request, String fileName) {
        String realPath = request.getSession().getServletContext().getRealPath("");
        String savePath = null;
        savePath = File.separator.equals("\\") ? realPath.substring(0, realPath.lastIndexOf("\\")) : realPath.substring(0, realPath.lastIndexOf("/"));
        return savePath;
    }

    public static HttpServletRequest getRequest() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBasePath() {
        try {
            HttpServletRequest request = HtmlUtil.getRequest();
            return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, String> getRequestHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, request.getHeader(headerName));
        }
        return headers;
    }

    public static String getBasePath(ServletRequest request) {
        try {
            HttpServletRequest httpRequest = HtmlUtil.toHttp(request);
            return httpRequest.getScheme() + "://" + httpRequest.getServerName() + ":" + httpRequest.getServerPort() + httpRequest.getContextPath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBaseIpPath(ServletRequest request) {
        try {
            HttpServletRequest httpRequest = HtmlUtil.toHttp(request);
            return httpRequest.getScheme() + "://" + HtmlUtil.getIP(httpRequest) + ":" + httpRequest.getServerPort() + httpRequest.getContextPath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpServletRequest toHttp(ServletRequest request) {
        try {
            return (HttpServletRequest)request;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpServletResponse getResponse() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, String> getRequestUrlParam(String originalUrl) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (originalUrl.indexOf("?") != -1) {
            String params = originalUrl.substring(originalUrl.indexOf("?") + 1);
            String[] paramArray = params.split("&");
            ArrayList s = new ArrayList();
            Collections.addAll(s, paramArray);
            s.forEach(param -> {
                String[] entry = param.split("=");
                if (entry.length == 1) {
                    map.put(entry[0], "");
                } else {
                    map.put(entry[0], entry[1]);
                }
            });
        }
        return map;
    }
}

