/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.XmlWebApplicationContext;
import top.wboost.common.base.annotation.AutoWebApplicationConfig;
import top.wboost.common.log.entity.Logger;
import top.wboost.common.log.util.LoggerUtil;
import top.wboost.common.util.CollectionUtil;

@AutoWebApplicationConfig
public class XmlWebApplicationContextUtil
implements ApplicationContextAware,
BeanFactoryPostProcessor {
    private static Logger log = LoggerUtil.getLogger(XmlWebApplicationContextUtil.class);
    private static ApplicationContext applicationContext;

    public static Object getBean(String beanId) {
        try {
            Object bean = applicationContext.getBean(beanId);
            return bean;
        }
        catch (Exception e) {
            log.warn("mvc spring bean :{} cant find.", (Object)beanId);
            return null;
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            log.warn("mvc spring bean :{} cant find.", (Object)clazz.getName());
            return null;
        }
    }

    public static ApplicationContext getApplicationContext() {
        try {
            return applicationContext;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        applicationContext = arg0;
        log.info("init");
    }

    public static void setBean(String beanId, Class<?> clazz, Map<String, Object> properties) {
        ApplicationContext applicationContext = XmlWebApplicationContextUtil.getApplicationContext();
        XmlWebApplicationContext xmlWebApplicationContext = (XmlWebApplicationContext)applicationContext;
        ConfigurableListableBeanFactory beanFactory = xmlWebApplicationContext.getBeanFactory();
        if (xmlWebApplicationContext.getBeanFactory() instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
            if (!CollectionUtil.isEmpty(properties)) {
                properties.forEach((name, value) -> builder.addPropertyValue(name, value));
            }
            registry.registerBeanDefinition(beanId, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

