/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelUtil {
    private static final String EMPTY = "";
    private static final int DEFAULT_BEGIN_ROW = -1;

    public static List<Map<String, String>> readExcel(InputStream fileStream) throws Exception {
        return ExcelUtil.readExcel(fileStream, -1);
    }

    public static List<Map<String, String>> readExcel(InputStream fileStream, Integer beginRow) throws Exception {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Workbook workbook = WorkbookFactory.create((InputStream)fileStream);
        int sheetNum = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetNum; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            if (beginRow == -1) {
                beginRow = sheet.getFirstRowNum();
            }
            for (int j = beginRow.intValue(); j <= sheet.getLastRowNum(); ++j) {
                TreeMap<String, String> map = new TreeMap<String, String>();
                list.add(map);
                Row row = sheet.getRow(j);
                for (int k = row.getFirstCellNum(); k < row.getLastCellNum(); ++k) {
                    Cell cell = row.getCell(k);
                    if (cell == null) {
                        map.put(String.valueOf(k), EMPTY);
                        continue;
                    }
                    map.put(String.valueOf(k), row.getCell(k).toString());
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcelToHtml(List<Map<String, Object>> list, String[] titles, String[] titleCode, String fileName, HttpServletResponse response) {
        WritableWorkbook workbook = null;
        OutputStream os = null;
        try {
            response.setContentType("application/msexcel;charset=utf-8");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8") + ".xls");
            os = response.getOutputStream();
            workbook = jxl.Workbook.createWorkbook((OutputStream)os);
            WritableSheet sheet = workbook.createSheet("First Sheet", 0);
            sheet.getSettings().setDefaultColumnWidth(20);
            for (int i = 0; i < titles.length; ++i) {
                Label label = new Label(i, 0, titles[i]);
                sheet.addCell((WritableCell)label);
            }
            if (null == list || list.size() == 0) {
                workbook.write();
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> map = list.get(i);
                for (int j = 0; j < titles.length; ++j) {
                    Label label = null;
                    Object param = map.get(titleCode[j]);
                    if (map.get(titleCode[j]) != null || titleCode[j] != null) {
                        Number number = null;
                        if (param instanceof Integer) {
                            int value = (Integer)param;
                            number = new Number(j, i + 1, (double)value);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (param instanceof String) {
                            String s = (String)param;
                            if ("price".equals(titleCode[j]) || "chrate".equals(titleCode[j])) {
                                int n = Integer.parseInt(s);
                                number = new Number(j, i + 1, (double)n);
                                sheet.addCell((WritableCell)number);
                                continue;
                            }
                            label = new Label(j, i + 1, s);
                            sheet.addCell((WritableCell)label);
                            continue;
                        }
                        if (param instanceof Double) {
                            double d = (Double)param;
                            number = new Number(j, i + 1, d);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (param instanceof Float) {
                            float f = ((Float)param).floatValue();
                            number = new Number(j, i + 1, (double)f);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (param instanceof Long) {
                            long l = (Long)param;
                            number = new Number(j, i + 1, (double)l);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (param instanceof BigDecimal) {
                            long b = ((BigDecimal)param).longValue();
                            number = new Number(j, i + 1, (double)b);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (!(param instanceof Date)) continue;
                        Date date = (Date)param;
                        String newDate = dateFormat.format(date);
                        label = new Label(j, i + 1, newDate);
                        sheet.addCell((WritableCell)label);
                        continue;
                    }
                    label = new Label(j, i + 1, EMPTY);
                    sheet.addCell((WritableCell)label);
                }
            }
            workbook.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (workbook != null) {
                    workbook.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

