/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class EtagUtil {
    private final int CHUNK_SIZE = 0x400000;

    public static String getEtagCode(String fileName) {
        EtagUtil etag = new EtagUtil();
        String etagCode = "";
        try {
            etagCode = etag.calcETag(fileName);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println("Unsupported algorithm:" + ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println("IO Error:" + ex.getMessage());
        }
        return etagCode;
    }

    public static String getEtagCode(byte[] bytes) {
        EtagUtil etag = new EtagUtil();
        String etagCode = "";
        try {
            etagCode = etag.calcETag(bytes);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println("Unsupported algorithm:" + ex.getMessage());
        }
        return etagCode;
    }

    public byte[] sha1(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest mDigest = MessageDigest.getInstance("sha1");
        return mDigest.digest(data);
    }

    public String urlSafeBase64Encode(byte[] data) {
        String encodedString = DatatypeConverter.printBase64Binary((byte[])data);
        encodedString = encodedString.replace('+', '-').replace('/', '_');
        return encodedString;
    }

    public String calcETag(String fileName) throws IOException, NoSuchAlgorithmException {
        String etag = "";
        File file = new File(fileName);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            System.err.println("Error: File not found or not readable");
            return etag;
        }
        long fileLength = file.length();
        FileInputStream inputStream = new FileInputStream(file);
        if (fileLength <= 0x400000L) {
            byte[] fileData = new byte[(int)fileLength];
            inputStream.read(fileData, 0, (int)fileLength);
            byte[] sha1Data = this.sha1(fileData);
            int sha1DataLen = sha1Data.length;
            byte[] hashData = new byte[sha1DataLen + 1];
            System.arraycopy(sha1Data, 0, hashData, 1, sha1DataLen);
            hashData[0] = 22;
            etag = this.urlSafeBase64Encode(hashData);
        } else {
            int chunkCount = (int)(fileLength / 0x400000L);
            if (fileLength % 0x400000L != 0L) {
                ++chunkCount;
            }
            byte[] allSha1Data = new byte[]{};
            for (int i = 0; i < chunkCount; ++i) {
                byte[] chunkData = new byte[0x400000];
                int bytesReadLen = inputStream.read(chunkData, 0, 0x400000);
                byte[] bytesRead = new byte[bytesReadLen];
                System.arraycopy(chunkData, 0, bytesRead, 0, bytesReadLen);
                byte[] chunkDataSha1 = this.sha1(bytesRead);
                byte[] newAllSha1Data = new byte[chunkDataSha1.length + allSha1Data.length];
                System.arraycopy(allSha1Data, 0, newAllSha1Data, 0, allSha1Data.length);
                System.arraycopy(chunkDataSha1, 0, newAllSha1Data, allSha1Data.length, chunkDataSha1.length);
                allSha1Data = newAllSha1Data;
            }
            byte[] allSha1DataSha1 = this.sha1(allSha1Data);
            byte[] hashData = new byte[allSha1DataSha1.length + 1];
            System.arraycopy(allSha1DataSha1, 0, hashData, 1, allSha1DataSha1.length);
            hashData[0] = -106;
            etag = this.urlSafeBase64Encode(hashData);
        }
        inputStream.close();
        return etag;
    }

    public String calcETag(byte[] bytes) throws NoSuchAlgorithmException {
        String etag = "";
        long fileLength = bytes.length;
        if (fileLength <= 0x400000L) {
            byte[] fileData = bytes;
            byte[] sha1Data = this.sha1(fileData);
            int sha1DataLen = sha1Data.length;
            byte[] hashData = new byte[sha1DataLen + 1];
            System.arraycopy(sha1Data, 0, hashData, 1, sha1DataLen);
            hashData[0] = 22;
            etag = this.urlSafeBase64Encode(hashData);
        } else {
            int chunkCount = (int)(fileLength / 0x400000L);
            if (fileLength % 0x400000L != 0L) {
                ++chunkCount;
            }
            byte[] allSha1Data = new byte[]{};
            for (int i = 0; i < chunkCount; ++i) {
                byte[] chunkData = new byte[0x400000];
                int bytesReadLen = 0;
                bytesReadLen = bytes.length - i * 0x400000 > 0x400000 ? 0x400000 : bytes.length - i * 0x400000;
                System.arraycopy(bytes, i * 0x400000, chunkData, 0, bytesReadLen);
                byte[] bytesRead = new byte[bytesReadLen];
                System.arraycopy(chunkData, 0, bytesRead, 0, bytesReadLen);
                byte[] chunkDataSha1 = this.sha1(bytesRead);
                byte[] newAllSha1Data = new byte[chunkDataSha1.length + allSha1Data.length];
                System.arraycopy(allSha1Data, 0, newAllSha1Data, 0, allSha1Data.length);
                System.arraycopy(chunkDataSha1, 0, newAllSha1Data, allSha1Data.length, chunkDataSha1.length);
                allSha1Data = newAllSha1Data;
            }
            byte[] allSha1DataSha1 = this.sha1(allSha1Data);
            byte[] hashData = new byte[allSha1DataSha1.length + 1];
            System.arraycopy(allSha1DataSha1, 0, hashData, 1, allSha1DataSha1.length);
            hashData[0] = -106;
            etag = this.urlSafeBase64Encode(hashData);
        }
        return etag;
    }
}

