/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class DownloadUtil {
    public static void download(String fileName, File file, HttpServletResponse response) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            DownloadUtil.download(fileName, inputStream, null, response);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void download(String fileName, File file, Map<String, String> dataMap, HttpServletResponse response) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            DownloadUtil.download(fileName, inputStream, dataMap, response);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void download(String fileName, byte[] bytes, HttpServletResponse response) {
        DownloadUtil.download(fileName, new ByteArrayInputStream(bytes), null, response);
    }

    public static void download(String fileName, byte[] bytes, Map<String, String> dataMap, HttpServletResponse response) {
        DownloadUtil.download(fileName, new ByteArrayInputStream(bytes), dataMap, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String fileName, InputStream inputStream, Map<String, String> dataMap, HttpServletResponse response) {
        block8: {
            ServletOutputStream outputStream = null;
            BufferedInputStream bis = null;
            try {
                int length;
                response.setCharacterEncoding("utf-8");
                response.setContentType("multipart/form-data");
                response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileName, "utf-8"));
                if (null != dataMap) {
                    for (Map.Entry<String, String> mapEntry : dataMap.entrySet()) {
                        response.setHeader(URLEncoder.encode(mapEntry.getKey(), "utf-8"), URLEncoder.encode(mapEntry.getValue(), "utf-8"));
                    }
                }
                bis = new BufferedInputStream(inputStream);
                outputStream = response.getOutputStream();
                byte[] b = new byte[1024];
                while ((length = bis.read(b)) > 0) {
                    outputStream.write(b, 0, length);
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

