/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import top.wboost.common.utils.web.utils.DateUtil;

public class ConvertUtil {
    public static Map<String, Object> beanConvertToMap(Object bean) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            Class<?> type = bean.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (propertyName.equals("class")) continue;
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean, new Object[0]);
                if (result != null) {
                    returnMap.put(propertyName, result);
                    continue;
                }
                returnMap.put(propertyName, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    public static <T> T mapConvertToBean(Map<String, Object> map, Class<T> type) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        try {
            Assert.notNull(type);
            T bean = type.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                Object propertyValue = map.get(propertyName);
                if (propertyName.equals("class") || propertyValue == null || String.valueOf(propertyValue).equals("")) continue;
                Class<?> clazz = descriptor.getPropertyType();
                Object propert = null;
                if (clazz.isPrimitive() || clazz.isAssignableFrom(propertyValue.getClass())) {
                    propert = propertyValue;
                } else {
                    String value = String.valueOf(propertyValue);
                    propert = String.class.equals(clazz) ? propertyValue : (Date.class.equals(clazz) ? DateUtil.parse(value, "yyyy-MM-dd") : (Timestamp.class.equals(clazz) ? new Timestamp(dateFormat.parse(value).getTime()) : NumberUtils.parseNumber((String)value, clazz)));
                }
                if (null == propert) continue;
                Method writeMethod = descriptor.getWriteMethod();
                writeMethod.invoke(bean, propert);
            }
            return bean;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public static <T> Object parseArraytoClassArray(Object array, Class<T> toClazz) {
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            Object retArray = Array.newInstance(toClazz, length);
            for (int i = 0; i < length; ++i) {
                T retObject = toClazz.cast(Array.get(array, i));
                Array.set(retArray, i, retObject);
            }
            return retArray;
        }
        return null;
    }

    public static List<Map<String, Object>> parseObjToMap(List<Object> objList, String[] fieldName) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        objList.forEach(obj -> {
            List<Object> tempList = null;
            if (obj.getClass().isArray()) {
                Object[] objArray = (Object[])obj;
                tempList = Arrays.asList(objArray);
            } else if (obj instanceof List) {
                tempList = (List<Object>)obj;
            } else {
                tempList = new ArrayList<Object>();
                tempList.add(obj);
            }
            LinkedHashMap<String, Object> tempMap = new LinkedHashMap<String, Object>();
            for (int i = 0; tempList != null && i < tempList.size(); ++i) {
                tempMap.put(fieldName[i], tempList.get(i));
            }
            retList.add(tempMap);
        });
        return retList;
    }
}

