/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.fsg.uid.impl;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.baidu.fsg.uid.UidGenerator;
import com.baidu.fsg.uid.exception.UidGenerateException;

public class HuToolUidGenerator
implements UidGenerator {
    private final Snowflake snowflake;

    public HuToolUidGenerator(long workerId, long datacenterId) {
        this.snowflake = IdUtil.getSnowflake((long)workerId, (long)datacenterId);
    }

    @Override
    public long getUid() throws UidGenerateException {
        return this.snowflake.nextId();
    }

    @Override
    public String parseUid(long uid) {
        long workerId = this.snowflake.getWorkerId(uid);
        long dataCenterId = this.snowflake.getDataCenterId(uid);
        long timestamp = this.snowflake.getGenerateDateTime(uid);
        return String.format("{\"UID\":\"%d\",\"timestamp\":\"%d\",\"workerId\":\"%d\",\"dataCenterId\":\"%d\"}", uid, timestamp, workerId, dataCenterId);
    }
}

