/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.request;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import top.tangyh.basic.database.mybatis.conditions.Wraps;

@Schema(description="\u5206\u9875\u53c2\u6570")
public class PageParams<T> {
    @NotNull(message="\u67e5\u8be2\u5bf9\u8c61model\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u67e5\u8be2\u53c2\u6570", required=true)
    private @NotNull(message="\u67e5\u8be2\u5bf9\u8c61model\u4e0d\u80fd\u4e3a\u7a7a") T model;
    @Schema(description="\u9875\u9762\u5927\u5c0f", example="10")
    private long size = 10L;
    @Schema(description="\u5f53\u524d\u9875", example="1")
    private long current = 1L;
    @Schema(description="\u6392\u5e8f,\u9ed8\u8ba4createTime", allowableValues={"id,createTime,updateTime"}, example="id")
    private String sort = "id";
    @Schema(description="\u6392\u5e8f\u89c4\u5219, \u9ed8\u8ba4descending", allowableValues={"descending,ascending"}, example="descending")
    private String order = "descending";
    @Schema(description="\u6269\u5c55\u53c2\u6570")
    private Map<String, Object> extra = new HashMap<String, Object>(16);

    public PageParams(long current, long size) {
        this.size = size;
        this.current = current;
    }

    @JsonIgnore
    public <E> IPage<E> buildPage() {
        PageParams params = this;
        return new Page(params.getCurrent(), params.getSize());
    }

    @JsonIgnore
    public <E> IPage<E> buildPage(Class<?> entityClazz) {
        PageParams params = this;
        if (StrUtil.isEmpty((CharSequence)params.getSort())) {
            return new Page(params.getCurrent(), params.getSize());
        }
        Page page = new Page(params.getCurrent(), params.getSize());
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        String[] sortArr = StrUtil.splitToArray((CharSequence)params.getSort(), (CharSequence)",");
        String[] orderArr = StrUtil.splitToArray((CharSequence)params.getOrder(), (CharSequence)",");
        int len = Math.min(sortArr.length, orderArr.length);
        for (int i = 0; i < len; ++i) {
            String humpSort = sortArr[i];
            String underlineSort = Wraps.getDbField((String)humpSort, entityClazz);
            orders.add(StrUtil.equalsAny((CharSequence)orderArr[i], (CharSequence[])new CharSequence[]{"ascending", "ascend"}) ? OrderItem.asc((String)underlineSort) : OrderItem.desc((String)underlineSort));
        }
        page.setOrders(orders);
        return page;
    }

    @JsonIgnore
    public long offset() {
        long current = this.current;
        if (current <= 1L) {
            return 0L;
        }
        return (current - 1L) * this.size;
    }

    @JsonIgnore
    public PageParams<T> put(String key, Object value) {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>(16);
        }
        this.extra.put(key, value);
        return this;
    }

    @JsonIgnore
    public PageParams<T> putAll(Map<String, Object> extra) {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>(16);
        }
        this.extra.putAll(extra);
        return this;
    }

    public T getModel() {
        return this.model;
    }

    public long getSize() {
        return this.size;
    }

    public long getCurrent() {
        return this.current;
    }

    public String getSort() {
        return this.sort;
    }

    public String getOrder() {
        return this.order;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageParams)) {
            return false;
        }
        PageParams other = (PageParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        T this$model = this.getModel();
        T other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        Map<String, Object> this$extra = this.getExtra();
        Map<String, Object> other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $current = this.getCurrent();
        result = result * 59 + (int)($current >>> 32 ^ $current);
        T $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        Map<String, Object> $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        return result;
    }

    public String toString() {
        return "PageParams(model=" + this.getModel() + ", size=" + this.getSize() + ", current=" + this.getCurrent() + ", sort=" + this.getSort() + ", order=" + this.getOrder() + ", extra=" + this.getExtra() + ")";
    }

    public PageParams() {
    }
}

