/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.echo.manager;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.annotation.echo.Echo;
import top.tangyh.basic.echo.manager.LoadKey;
import top.tangyh.basic.interfaces.echo.LoadService;

public class CacheLoadKeys {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheLoadKeys.class);
    private String api;
    private Set<Serializable> keys = new HashSet<Serializable>();
    private LoadService loadService;

    public CacheLoadKeys(Echo rf) {
        this.api = rf.api();
    }

    public CacheLoadKeys(LoadKey lk, LoadService loadService, Set<Serializable> keys) {
        this.api = lk.getApi();
        this.loadService = loadService;
        this.keys = keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheLoadKeys that = (CacheLoadKeys)o;
        boolean apiMethod = Objects.equal((Object)this.api, (Object)that.api);
        boolean isEqualsKeys = this.keys.size() == that.keys.size() && this.keys.containsAll(that.keys);
        return apiMethod && isEqualsKeys;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.api, this.keys});
    }

    public Map<Serializable, Object> loadMap() {
        return this.loadService.findByIds(this.keys);
    }

    @Generated
    public String getApi() {
        return this.api;
    }

    @Generated
    public Set<Serializable> getKeys() {
        return this.keys;
    }

    @Generated
    public LoadService getLoadService() {
        return this.loadService;
    }

    @Generated
    public void setApi(String api) {
        this.api = api;
    }

    @Generated
    public void setKeys(Set<Serializable> keys) {
        this.keys = keys;
    }

    @Generated
    public void setLoadService(LoadService loadService) {
        this.loadService = loadService;
    }

    @Generated
    public CacheLoadKeys() {
    }

    @Generated
    public String toString() {
        return "CacheLoadKeys(api=" + this.getApi() + ", keys=" + this.getKeys() + ", loadService=" + this.getLoadService() + ")";
    }
}

